/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.random.MurmurHash3;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.effects.particles.BubbleBreathParticle;
import org.orecruncher.mobeffects.effects.particles.FrostBreathParticle;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityBreathEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "breath");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new EntityBreathEffect());
    private int seed;

    public EntityBreathEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager state) {
        super.intitialize(state);
        this.seed = MurmurHash3.hash(this.getEntity().func_145782_y()) & 0xFFFF;
    }

    @Override
    public void update() {
        LivingEntity entity = this.getEntity();
        if (this.isBreathVisible(entity)) {
            int c = (int)(TickCounter.getTickCount() + (long)this.seed);
            BlockPos headPos = this.getHeadPosition(entity);
            BlockState state = entity.func_130014_f_().func_180495_p(headPos);
            if (this.showWaterBubbles(state)) {
                int air = entity.func_70086_ai();
                if (air > 0) {
                    int interval = c % 3;
                    if (interval == 0) {
                        this.createBubbleParticle(false);
                    }
                } else if (air == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.createBubbleParticle(true);
                    }
                }
            } else {
                int interval = c / 10 % 8;
                if (interval < 3 && this.showFrostBreath(entity, state, headPos)) {
                    this.createFrostParticle();
                }
            }
        }
    }

    protected boolean isBreathVisible(@Nonnull LivingEntity entity) {
        PlayerEntity player = GameUtils.getPlayer();
        if (entity == player) {
            return !player.func_175149_v() && !GameUtils.getGameSettings().field_74319_N;
        }
        return !entity.func_98034_c(player) && player.func_70685_l((Entity)entity);
    }

    protected BlockPos getHeadPosition(@Nonnull LivingEntity entity) {
        double d0 = entity.func_226278_cu_() + (double)entity.func_70047_e();
        return new BlockPos(entity.func_226277_ct_(), d0, entity.func_226281_cx_());
    }

    protected boolean showWaterBubbles(@Nonnull BlockState headBlock) {
        return headBlock.func_185904_a().func_76224_d();
    }

    protected boolean showFrostBreath(LivingEntity entity, @Nonnull BlockState headBlock, @Nonnull BlockPos pos) {
        if (headBlock.func_185904_a() == Material.field_151579_a) {
            World world = entity.func_130014_f_();
            return WorldUtils.isColdTemperature(WorldUtils.getTemperatureAt(world, pos));
        }
        return false;
    }

    protected void createBubbleParticle(boolean isDrowning) {
        BubbleBreathParticle p = new BubbleBreathParticle(this.getEntity(), isDrowning);
        this.addParticle((Particle)p);
    }

    protected void createFrostParticle() {
        FrostBreathParticle p = new FrostBreathParticle(this.getEntity());
        this.addParticle((Particle)p);
    }
}

