/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.math.LoggingTimerEMA;
import org.orecruncher.lib.math.TimerEMA;
import org.orecruncher.lib.particles.BaseParticle;
import org.orecruncher.lib.particles.FrustumHelper;
import org.orecruncher.lib.particles.IParticleMote;

@OnlyIn(value=Dist.CLIENT)
final class ParticleCollection
extends BaseParticle {
    public static final ICollectionFactory FACTORY = ParticleCollection::new;
    protected static final int MAX_PARTICLES = 4000;
    protected static final int ALLOCATION_SIZE = 128;
    protected static final int TICK_GRACE = 2;
    private static final Predicate<IParticleMote> UPDATE_REMOVE = mote -> !mote.tick();
    protected final LoggingTimerEMA render;
    protected final LoggingTimerEMA tick;
    protected final ObjectArray<IParticleMote> myParticles = new ObjectArray(128);
    protected final IParticleRenderType renderType;
    protected long lastTickUpdate;

    ParticleCollection(@Nonnull String name, @Nonnull World world, @Nonnull IParticleRenderType renderType) {
        super(world, 0.0, 0.0, 0.0);
        this.field_190017_n = false;
        this.renderType = renderType;
        this.render = new LoggingTimerEMA("Render " + name);
        this.tick = new LoggingTimerEMA("Tick " + name);
        this.lastTickUpdate = TickCounter.getTickCount();
    }

    public boolean canFit() {
        return this.myParticles.size() < 4000;
    }

    public void addParticle(@Nonnull IParticleMote mote) {
        if (this.canFit()) {
            this.myParticles.add(mote);
        }
    }

    public int size() {
        return this.myParticles.size();
    }

    @Nonnull
    public TimerEMA getRenderTimer() {
        return this.render;
    }

    @Nonnull
    public TimerEMA getTickTimer() {
        return this.tick;
    }

    public boolean shouldDie() {
        boolean timeout = TickCounter.getTickCount() - this.lastTickUpdate > 2L;
        return timeout || this.size() == 0 || this.field_187122_b != GameUtils.getWorld();
    }

    public void func_189213_a() {
        this.tick.begin();
        if (this.func_187113_k()) {
            this.lastTickUpdate = TickCounter.getTickCount();
            this.myParticles.removeIf(UPDATE_REMOVE);
            if (this.shouldDie()) {
                this.func_187112_i();
            }
        }
        this.tick.end();
    }

    public boolean shouldCull() {
        return false;
    }

    public void func_225606_a_(@Nonnull IVertexBuilder buffer, @Nonnull ActiveRenderInfo renderInfo, float partialTicks) {
        this.render.begin();
        for (IParticleMote mote : this.myParticles) {
            if (!FrustumHelper.isLocationInFrustum(mote.getPosition())) continue;
            mote.renderParticle(buffer, renderInfo, partialTicks);
        }
        this.render.end();
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return this.renderType;
    }

    public static interface ICollectionFactory {
        public ParticleCollection create(@Nonnull String var1, @Nonnull World var2, @Nonnull IParticleRenderType var3);
    }
}

