/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.gui.Color;
import org.orecruncher.lib.particles.MotionMote;
import org.orecruncher.lib.particles.ParticleCollisionResult;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public abstract class AnimatedMote
extends MotionMote {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected float baseAirFriction = 0.91f;
    protected float fadeTargetRed;
    protected float fadeTargetGreen;
    protected float fadeTargetBlue;
    protected boolean fadingColor;
    protected float dRed;
    protected float dGreen;
    protected float dBlue;
    protected double xAcceleration;
    protected double yAcceleration;
    protected double zAcceleration;
    protected float texU1;
    protected float texU2;
    protected float texV1;
    protected float texV2;
    protected float particleScale;
    protected final IAnimatedSprite sprites;

    protected AnimatedMote(@Nonnull IAnimatedSprite sprites, @Nonnull IBlockReader world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.sprites = sprites;
        this.particleScale = (RANDOM.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    public void setColor(int rgb) {
        this.red = (float)((rgb & 0xFF0000) >> 16) / 255.0f;
        this.green = (float)((rgb & 0xFF00) >> 8) / 255.0f;
        this.blue = (float)(rgb & 0xFF) / 255.0f;
        this.alpha = 0.99f;
    }

    public void setColor(@Nonnull Color color) {
        this.red = color.red();
        this.green = color.green();
        this.blue = color.blue();
        this.alpha = 0.99f;
    }

    public void setColorFade(int rgb) {
        this.fadeTargetRed = (float)((rgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeTargetGreen = (float)((rgb & 0xFF00) >> 8) / 255.0f;
        this.fadeTargetBlue = (float)(rgb & 0xFF) / 255.0f;
        this.fadingColor = true;
        this.lerpColors();
    }

    public void setColorFade(@Nonnull Color color) {
        this.fadeTargetRed = color.red();
        this.fadeTargetGreen = color.green();
        this.fadeTargetBlue = color.blue();
        this.lerpColors();
    }

    private void lerpColors() {
        float scaling = 1.0f / (float)this.maxAge;
        this.dRed = MathHelper.func_219799_g((float)scaling, (float)this.red, (float)this.fadeTargetRed);
        this.dGreen = MathHelper.func_219799_g((float)scaling, (float)this.green, (float)this.fadeTargetGreen);
        this.dBlue = MathHelper.func_219799_g((float)scaling, (float)this.blue, (float)this.fadeTargetBlue);
    }

    @Override
    public void handleCollision(@Nonnull ParticleCollisionResult collision) {
        this.motionX *= (double)0.7f;
        this.motionZ *= (double)0.7f;
    }

    @Override
    public void update() {
        this.motionY += this.yAcceleration;
        this.motionX += this.xAcceleration;
        this.motionZ += this.zAcceleration;
        this.motionX *= (double)this.baseAirFriction;
        this.motionY *= (double)this.baseAirFriction;
        this.motionZ *= (double)this.baseAirFriction;
        super.update();
        if (this.isAlive()) {
            if (this.age > this.maxAge / 2) {
                this.alpha = (int)((1.0f - ((float)this.age - (float)(this.maxAge / 2)) / (float)this.maxAge) * 254.0f);
                if (this.fadingColor) {
                    this.red += this.dRed;
                    this.green += this.dGreen;
                    this.blue += this.dBlue;
                }
            }
            this.setParticleTexture();
        }
    }

    @Override
    public void updateBrightness() {
        this.packedLighting = 0xF000F0;
    }

    @Override
    public void renderParticle(@Nonnull IVertexBuilder buffer, @Nonnull ActiveRenderInfo info, float partialTicks) {
        float x = this.renderX(info, partialTicks);
        float y = this.renderY(info, partialTicks);
        float z = this.renderZ(info, partialTicks);
        Quaternion quaternion = info.func_227995_f_();
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(this.particleScale);
            vector3f.func_195904_b(x, y, z);
        }
        this.drawVertex(buffer, avector3f[0].func_195899_a(), avector3f[0].func_195900_b(), avector3f[0].func_195902_c(), this.texU2, this.texV2);
        this.drawVertex(buffer, avector3f[1].func_195899_a(), avector3f[1].func_195900_b(), avector3f[1].func_195902_c(), this.texU2, this.texV1);
        this.drawVertex(buffer, avector3f[2].func_195899_a(), avector3f[2].func_195900_b(), avector3f[2].func_195902_c(), this.texU1, this.texV1);
        this.drawVertex(buffer, avector3f[3].func_195899_a(), avector3f[3].func_195900_b(), avector3f[3].func_195902_c(), this.texU1, this.texV2);
    }

    public void setParticleTexture() {
        TextureAtlasSprite texture = this.sprites.func_217591_a(this.age, this.maxAge);
        this.texU1 = texture.func_94209_e();
        this.texU2 = texture.func_94212_f();
        this.texV1 = texture.func_94206_g();
        this.texV2 = texture.func_94210_h();
    }
}

