/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.EnumMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBatcherTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IStateBasedDirectional {
    public static final int NUM_SLOTS = 9;
    private final NonNullList<ItemStack> filters = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> buffers = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public BatchMode batchMode = BatchMode.ALL;
    public NonNullList<DyeColor> redstoneColors = NonNullList.func_191197_a((int)9, (Object)DyeColor.WHITE);
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntityAt(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177972_a(this.getFacing()), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final LazyOptional<IItemHandler> insertionCap = this.registerConstantCap(new IEInventoryHandler(9, (IIEInventory)this, 0, true, false));
    private final LazyOptional<CapabilityRedstoneNetwork.RedstoneBundleConnection> redstoneCap = this.registerConstantCap(new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

        @Override
        public void updateInput(byte[] signals, ConnectionPoint cp, Direction side) {
            Set<DyeColor> outputMap = ItemBatcherTileEntity.this.calculateRedstoneOutputs();
            for (DyeColor dye : outputMap) {
                signals[dye.func_196059_a()] = (byte)Math.max(signals[dye.func_196059_a()], 15);
            }
        }
    });

    public ItemBatcherTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.ITEM_BATCHER.get()));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.func_225608_bj_();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 8L == 0L && this.output.isPresent() && this.isActive()) {
            int slot;
            boolean matched = true;
            if (this.batchMode == BatchMode.ALL) {
                for (slot = 0; slot < 9; ++slot) {
                    if (((ItemStack)this.filters.get(slot)).func_190926_b()) continue;
                    matched &= this.isFilterMatched(slot);
                }
            }
            if (matched) {
                for (slot = 0; slot < 9; ++slot) {
                    ItemStack filterStack = (ItemStack)this.filters.get(slot);
                    if (filterStack.func_190926_b() || this.batchMode != BatchMode.ALL && !this.isFilterMatched(slot)) continue;
                    ItemStack outStack = (ItemStack)this.buffers.get(slot);
                    int outSize = filterStack.func_190916_E();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)outStack, (int)outSize);
                    if (!(stack = Utils.insertStackIntoInventory(this.output, stack, false)).func_190926_b()) {
                        outSize -= stack.func_190916_E();
                    }
                    outStack.func_190918_g(outSize);
                    if (outStack.func_190916_E() > 0) continue;
                    this.buffers.set(slot, (Object)ItemStack.field_190927_a);
                }
                this.redstoneCap.ifPresent(CapabilityRedstoneNetwork.RedstoneBundleConnection::markDirty);
            }
        }
    }

    protected boolean isActive() {
        return !this.isRSPowered();
    }

    protected boolean isFilterMatched(int slot) {
        return ItemStack.func_185132_d((ItemStack)((ItemStack)this.filters.get(slot)), (ItemStack)((ItemStack)this.buffers.get(slot))) && ((ItemStack)this.buffers.get(slot)).func_190916_E() >= ((ItemStack)this.filters.get(slot)).func_190916_E();
    }

    protected Set<DyeColor> calculateRedstoneOutputs() {
        EnumMap<DyeColor, Boolean> map = new EnumMap<DyeColor, Boolean>(DyeColor.class);
        for (int slot = 0; slot < 9; ++slot) {
            DyeColor dye;
            if (((ItemStack)this.filters.get(slot)).func_190926_b()) continue;
            Boolean ex = (Boolean)map.get(dye = (DyeColor)this.redstoneColors.get(slot));
            map.put(dye, ex != null ? ex.booleanValue() && this.isFilterMatched(slot) : this.isFilterMatched(slot));
        }
        return map.keySet().stream().filter(map::get).collect(Collectors.toSet());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)merged);
            for (i = 0; i < 9; ++i) {
                this.buffers.set(i, (Object)((ItemStack)merged.get(i + 9)));
                this.filters.set(i, (Object)((ItemStack)merged.get(i)));
            }
        }
        this.batchMode = BatchMode.values()[nbt.func_74771_c("batchMode")];
        int[] redstoneConfig = nbt.func_74759_k("redstoneColors");
        if (redstoneConfig.length >= 9) {
            for (i = 0; i < 9; ++i) {
                this.redstoneColors.set(i, (Object)DyeColor.func_196056_a((int)redstoneConfig[i]));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            for (i = 0; i < 9; ++i) {
                merged.set(i + 9, (Object)((ItemStack)this.buffers.get(i)));
                merged.set(i, (Object)((ItemStack)this.filters.get(i)));
            }
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, (NonNullList)merged);
        }
        nbt.func_74774_a("batchMode", (byte)this.batchMode.ordinal());
        int[] redstoneConfig = new int[9];
        for (i = 0; i < 9; ++i) {
            redstoneConfig[i] = ((DyeColor)this.redstoneColors.get(i)).func_196059_a();
        }
        nbt.func_74783_a("redstoneColors", redstoneConfig);
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_74764_b("batchMode")) {
            this.batchMode = BatchMode.values()[message.func_74771_c("batchMode")];
        }
        if (message.func_74764_b("redstoneColor_slot") && message.func_74764_b("redstoneColor_val")) {
            this.redstoneColors.set(message.func_74762_e("redstoneColor_slot"), (Object)DyeColor.func_196056_a((int)message.func_74762_e("redstoneColor_val")));
        }
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.buffers;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return ItemStack.func_185132_d((ItemStack)((ItemStack)this.filters.get(slot)), (ItemStack)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.redstoneCap.ifPresent(CapabilityRedstoneNetwork.RedstoneBundleConnection::markDirty);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == this.getFacing().func_176734_d()) {
            return this.insertionCap.cast();
        }
        if (capability == CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION) {
            return this.redstoneCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public static enum BatchMode {
        SINGLE,
        ALL;

    }
}

