/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.events.EventBusHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class JEIClientConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ClientConfig clientConfig = new ClientConfig(builder);
    public static final IngredientFilterConfig filterConfig = new IngredientFilterConfig(builder);
    public static final ModIdFormattingConfig modNameFormat = new ModIdFormattingConfig(builder);
    private static final ForgeConfigSpec config = builder.build();
    private static boolean ftbLibraryLoaded = false;
    private static final String TRANSLATION_KEY = "config.jei";

    public static void register(IEventBus modEventBus) {
        EventBusHelper.addListener(modEventBus, FMLCommonSetupEvent.class, JEIClientConfig::commonSetup);
        EventBusHelper.addListener(modEventBus, ModConfig.ModConfigEvent.class, JEIClientConfig::reload);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, config);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        ftbLibraryLoaded = ModList.get().isLoaded("ftblibrary");
    }

    public static void reload(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() != config) {
            return;
        }
        clientConfig.reload();
        filterConfig.reload();
        modNameFormat.reload();
    }

    public static void openSettings() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (ftbLibraryLoaded) {
            ConfigGroup group = new ConfigGroup(TRANSLATION_KEY);
            clientConfig.buildSettingsGUI(group);
            filterConfig.buildSettingsGUI(group);
            modNameFormat.buildSettingsGUI(group);
            EditConfigScreen gui = new EditConfigScreen(group);
            group.savedCallback = b -> {
                if (b) {
                    config.save();
                }
                mc.func_147108_a((Screen)new InventoryScreen((PlayerEntity)mc.field_71439_g));
            };
            gui.openGui();
        } else {
            mc.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("jei.message.ftblibrary").func_230530_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/ftb-library-forge"))), false);
        }
    }
}

