/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.ClientConfigValues;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IJEIConfig;
import mezz.jei.ingredients.IngredientSortStage;
import mezz.jei.util.GiveMode;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientConfig
implements IJEIConfig,
IClientConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static IClientConfig instance;
    public static final int smallestNumColumns = 4;
    public static final int largestNumColumns = 100;
    public static final int minRecipeGuiHeight = 175;
    private final ClientConfigValues values;
    private List<? extends String> searchColors = Arrays.asList(ColorGetter.getColorDefaults());
    public static final List<IngredientSortStage> ingredientSorterStagesDefault;
    private List<IngredientSortStage> ingredientSorterStages = ingredientSorterStagesDefault;
    private final ForgeConfigSpec.BooleanValue debugModeEnabled;
    private final ForgeConfigSpec.BooleanValue centerSearchBarEnabled;
    private final ForgeConfigSpec.BooleanValue lowMemorySlowSearchEnabled;
    private final ForgeConfigSpec.EnumValue<GiveMode> giveMode;
    private final ForgeConfigSpec.IntValue maxColumns;
    private final ForgeConfigSpec.IntValue maxRecipeGuiHeight;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> searchColorsCfg;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> ingredientSorterStagesCfg;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        instance = this;
        this.values = new ClientConfigValues();
        ClientConfigValues defaultValues = new ClientConfigValues();
        builder.push("advanced");
        builder.comment("Debug mode enabled");
        this.debugModeEnabled = builder.define("DebugMode", defaultValues.debugModeEnabled);
        builder.comment("Display search bar in the center");
        this.centerSearchBarEnabled = builder.define("CenterSearch", defaultValues.centerSearchBarEnabled);
        builder.comment("Set low-memory mode (makes search very slow, but uses less RAM)");
        this.lowMemorySlowSearchEnabled = builder.define("LowMemorySlowSearchEnabled", defaultValues.lowMemorySlowSearchEnabled);
        builder.comment("How items should be handed to you");
        this.giveMode = builder.defineEnum("GiveMode", (Enum)defaultValues.giveMode);
        builder.comment("Max number of columns shown");
        this.maxColumns = builder.defineInRange("MaxColumns", defaultValues.maxColumns, 4, 100);
        builder.comment("Max. recipe gui height");
        this.maxRecipeGuiHeight = builder.defineInRange("RecipeGuiHeight", defaultValues.maxRecipeGuiHeight, 175, Integer.MAX_VALUE);
        builder.pop();
        builder.push("colors");
        builder.comment("Color values to search for");
        this.searchColorsCfg = builder.defineList("SearchColors", (List)Lists.newArrayList((Object[])ColorGetter.getColorDefaults()), obj -> {
            String entry;
            String[] values;
            if (obj instanceof String && (values = (entry = (String)obj).split(":")).length == 2) {
                try {
                    Integer.decode("0x" + values[1]);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        });
        builder.pop();
        builder.push("sorting");
        builder.comment(String.format("Sorting order for the ingredient list. Valid stages: %s", Arrays.asList(IngredientSortStage.values())));
        List defaults = ingredientSorterStagesDefault.stream().map(Enum::name).collect(Collectors.toList());
        Predicate<Object> elementValidator = ClientConfig.validEnumElement(IngredientSortStage.class);
        this.ingredientSorterStagesCfg = builder.defineList("IngredientSortStages", defaults, elementValidator);
        builder.pop();
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public void buildSettingsGUI(ConfigGroup group) {
        ClientConfigValues defaultVals = new ClientConfigValues();
        group.addBool(this.cfgTranslation("centerSearchBarEnabled"), this.values.centerSearchBarEnabled, v -> {
            this.centerSearchBarEnabled.set(v);
            this.values.centerSearchBarEnabled = v;
        }, defaultVals.centerSearchBarEnabled);
        group.addEnum(this.cfgTranslation("giveMode"), (Object)this.values.giveMode, v -> {
            this.giveMode.set((Object)v);
            this.values.giveMode = v;
        }, NameMap.of((Object)((Object)defaultVals.giveMode), (Object[])GiveMode.values()).create());
        group.addInt(this.cfgTranslation("maxColumns"), this.values.maxColumns, v -> {
            this.maxColumns.set(v);
            this.values.maxColumns = v;
        }, defaultVals.maxColumns, 1, Integer.MAX_VALUE);
        group.addInt(this.cfgTranslation("maxRecipeGuiHeight"), this.values.maxRecipeGuiHeight, v -> {
            this.maxRecipeGuiHeight.set(v);
            this.values.maxRecipeGuiHeight = v;
        }, defaultVals.maxRecipeGuiHeight, 1, Integer.MAX_VALUE);
    }

    private String cfgTranslation(String name) {
        return "advanced." + name;
    }

    @Override
    public void reload() {
        this.values.debugModeEnabled = (Boolean)this.debugModeEnabled.get();
        this.values.centerSearchBarEnabled = (Boolean)this.centerSearchBarEnabled.get();
        this.values.lowMemorySlowSearchEnabled = (Boolean)this.lowMemorySlowSearchEnabled.get();
        this.values.giveMode = (GiveMode)((Object)this.giveMode.get());
        this.values.maxColumns = (Integer)this.maxColumns.get();
        this.values.maxRecipeGuiHeight = (Integer)this.maxRecipeGuiHeight.get();
        this.searchColors = (List)this.searchColorsCfg.get();
        this.ingredientSorterStages = ((List)this.ingredientSorterStagesCfg.get()).stream().map(s -> (IngredientSortStage)EnumUtils.getEnum(IngredientSortStage.class, (String)s)).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.ingredientSorterStages.isEmpty()) {
            this.ingredientSorterStages = ingredientSorterStagesDefault;
        }
        this.syncSearchColorsConfig();
    }

    @Override
    public boolean isDebugModeEnabled() {
        return this.values.debugModeEnabled;
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return this.values.centerSearchBarEnabled;
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return this.values.lowMemorySlowSearchEnabled;
    }

    @Override
    public GiveMode getGiveMode() {
        return this.values.giveMode;
    }

    @Override
    public int getMaxColumns() {
        return this.values.maxColumns;
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return this.values.maxRecipeGuiHeight;
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages;
    }

    private void syncSearchColorsConfig() {
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String string : this.searchColors) {
            String[] values = string.split(":");
            if (values.length != 2) {
                LOGGER.error("Invalid format for searchColor entry: {}", (Object)string);
                continue;
            }
            try {
                String name = values[0];
                Integer colorValue = Integer.decode("0x" + values[1]);
                searchColorsMapBuilder.put((Object)colorValue, (Object)name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid number format for searchColor entry: {}", (Object)string, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Integer, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
    }

    private static Predicate<Object> validEnumElement(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] enumConstants;
        HashSet<String> validEntries = new HashSet<String>();
        for (Enum<?> enumConstant : enumConstants = enumClass.getEnumConstants()) {
            String name = enumConstant.name();
            validEntries.add(name);
        }
        return obj -> {
            if (obj instanceof String) {
                String name = (String)obj;
                return validEntries.contains(name);
            }
            return false;
        };
    }

    static {
        ingredientSorterStagesDefault = Arrays.asList(IngredientSortStage.MOD_NAME, IngredientSortStage.INGREDIENT_TYPE, IngredientSortStage.CREATIVE_MENU, IngredientSortStage.ALPHABETICAL, IngredientSortStage.WEAPON_DAMAGE, IngredientSortStage.TOOL_TYPE, IngredientSortStage.ARMOR, IngredientSortStage.TAG);
    }
}

