/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.Main;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractInventoryBoat;
import com.talhanation.smallships.entities.TNBoatEntity;
import com.talhanation.smallships.init.SoundInit;
import com.talhanation.smallships.network.MessageIsForward;
import com.talhanation.smallships.network.MessageSailState;
import com.talhanation.smallships.network.MessageSteerState;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractSailBoat
extends AbstractInventoryBoat {
    private static final DataParameter<Boolean> IS_LEFT = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_RIGHT = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SAIL_STATE = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_FORWARD = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private double waterLevel;

    public AbstractSailBoat(EntityType<? extends TNBoatEntity> type, World world) {
        super(type, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsForward() && this.checkInWater()) {
            this.Watersplash();
        }
        if (this.func_184186_bw() && this.field_70170_p.field_72995_K) {
            this.sendSteerStateToServer();
            this.sendIsForwardToServer();
        }
        if (this.func_184179_bs() == null || !(this.func_184179_bs() instanceof PlayerEntity)) {
            this.setSailState(0);
            this.setIsForward(false);
        }
        if (((Boolean)SmallShipsConfig.WaterMobFlee.get()).booleanValue()) {
            double radius = 15.0;
            List list1 = this.field_70170_p.func_217357_a(WaterMobEntity.class, new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - radius, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, this.func_226278_cu_() + radius, this.func_226281_cx_() + radius));
            for (WaterMobEntity ent : list1) {
                this.fleeEntity((MobEntity)ent);
            }
        }
        if (this.getIsForward()) {
            this.knockBack(this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
            this.knockBack(this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
        }
    }

    public void tickLerp() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEFT, (Object)false);
        this.field_70180_af.func_187214_a(IS_RIGHT, (Object)false);
        this.field_70180_af.func_187214_a(IS_FORWARD, (Object)false);
        this.field_70180_af.func_187214_a(SAIL_STATE, (Object)0);
    }

    public boolean getSteerState(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(side == 0 ? IS_LEFT : IS_RIGHT) != false && this.func_184179_bs() != null;
    }

    public Integer getSailState() {
        return (Integer)this.field_70180_af.func_187225_a(SAIL_STATE);
    }

    public boolean getIsForward() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FORWARD);
    }

    public void setSailState(int state) {
        if (state != this.getSailState()) {
            this.playSailSound(state);
            this.field_70180_af.func_187227_b(SAIL_STATE, (Object)state);
        }
    }

    public void setSteerState(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(IS_LEFT, (Object)left);
        this.field_70180_af.func_187227_b(IS_RIGHT, (Object)right);
    }

    public void setIsForward(boolean forward) {
        this.field_70180_af.func_187227_b(IS_FORWARD, (Object)forward);
        if (this.getSailState() != 0) {
            this.field_70180_af.func_187227_b(IS_FORWARD, (Object)true);
        }
    }

    public void sendSailStateToServer(int state) {
        if (this.field_70170_p.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSailState(state));
        }
    }

    public void sendSteerStateToServer() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSteerState(this.getSteerState(0), this.getSteerState(1)));
    }

    public void sendIsForwardToServer() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageIsForward(this.getIsForward()));
    }

    public void playSailSound(int state) {
        if (state != 0) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), (SoundEvent)SoundInit.SHIP_SAIL_0.get(), this.func_184176_by(), 15.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
        } else {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), (SoundEvent)SoundInit.SHIP_SAIL_1.get(), this.func_184176_by(), 10.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
        }
    }

    @Override
    public void onKeyPressed() {
        int state = this.getSailState();
        state = state != 4 ? 4 : 0;
        this.sendSailStateToServer(state);
    }

    @Override
    public void onKeyLowerPressed() {
        int state = this.getSailState();
        if (state != 4) {
            ++state;
        }
        this.sendSailStateToServer(state);
    }

    @Override
    public void onKeyHigherPressed() {
        int state = this.getSailState();
        if (state != 0) {
            --state;
        }
        this.sendSailStateToServer(state);
    }

    public void fleeEntity(MobEntity entity) {
        double fleeDistance = 10.0;
        Vector3d vecBoat = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d vecEntity = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        Vector3d fleeDir = vecEntity.func_178788_d(vecBoat);
        fleeDir = fleeDir.func_72432_b();
        Vector3d fleePos = new Vector3d(vecEntity.field_72450_a + fleeDir.field_72450_a * fleeDistance, vecEntity.field_72448_b + fleeDir.field_72448_b * fleeDistance, vecEntity.field_72449_c + fleeDir.field_72449_c * fleeDistance);
        entity.func_70661_as().func_75492_a(fleePos.field_72450_a, fleePos.field_72448_b, fleePos.field_72449_c, 10.0);
    }

    private void knockBack(List<Entity> entities) {
        double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.func_226277_ct_() - d0;
            double d3 = entity.func_226281_cx_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.func_70024_g(d2 / d4 * 0.4, 0.0, d3 / d4 * 0.4);
        }
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

