/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.storage.ServerWorldInfo;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.block.GhastTrapBlock;
import twilightforest.block.TFBlocks;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.CarminiteGhastguardEntity;
import twilightforest.entity.CarminiteGhastlingEntity;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.entity.TFEntities;
import twilightforest.entity.boss.UrGhastFireballEntity;
import twilightforest.loot.TFTreasure;
import twilightforest.util.TFDamageSources;
import twilightforest.world.TFGenerationSettings;

public class UrGhastEntity
extends CarminiteGhastguardEntity {
    private static final DataParameter<Boolean> DATA_TANTRUM = EntityDataManager.func_187226_a(UrGhastEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final int HOVER_ALTITUDE = 20;
    private List<BlockPos> trapLocations;
    private int nextTantrumCry;
    private float damageUntilNextPhase = 10.0f;
    private boolean noTrapMode;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

    public UrGhastEntity(EntityType<? extends UrGhastEntity> type, World world) {
        super(type, world);
        this.wanderFactor = 32.0f;
        this.field_70145_X = true;
        this.setInTantrum(false);
        this.field_70728_aV = 317;
        this.field_70765_h = new NoClipMoveHelper((MobEntity)this);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return CarminiteGhastguardEntity.registerAttributes().func_233815_a_(Attributes.field_233818_a_, 250.0).func_233815_a_(Attributes.field_233819_b_, 128.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TANTRUM, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.trapLocations = new ArrayList<BlockPos>();
        this.field_70714_bg.field_220892_d.removeIf(e -> e.func_220772_j() instanceof CarminiteGhastguardEntity.AIHomedFly);
        this.field_70714_bg.func_75776_a(5, (Goal)new AIWaypointFly(this));
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            if (this.hasHome()) {
                this.field_70170_p.func_175656_a(this.func_213384_dI(), ((Block)TFBlocks.boss_spawner_ur_ghast.get()).func_176223_P());
            }
            this.func_70106_y();
        } else {
            super.func_70623_bb();
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return TFSounds.URGHAST_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFSounds.URGHAST_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TFSounds.URGHAST_DEATH;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        } else {
            if (this.isInTantrum()) {
                this.field_70170_p.func_195594_a((IParticleData)TFParticleType.BOSS_TEAR.get(), this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 0.75, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() * 0.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 0.75, 0.0, 0.0, 0.0);
            }
            if (this.field_70725_aQ > 0) {
                for (int k = 0; k < 5; ++k) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)(this.field_70146_Z.nextBoolean() ? ParticleTypes.field_197626_s : ParticleTypes.field_197627_t), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d, d1, d2);
                }
            }
        }
    }

    public boolean func_180431_b(DamageSource src) {
        return src == DamageSource.field_76368_d || src == DamageSource.field_76372_a || src == DamageSource.field_76370_b || super.func_180431_b(src);
    }

    public void func_233627_a_(float strength, double xRatio, double zRatio) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isInTantrum()) {
            damage /= 10.0f;
        }
        float oldHealth = this.func_110143_aJ();
        boolean attackSuccessful = "fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof PlayerEntity ? super.func_70097_a(DamageSource.func_76356_a((Entity)source.func_76346_g(), (Entity)source.func_76364_f()), damage) : super.func_70097_a(source, damage);
        float lastDamage = oldHealth - this.func_110143_aJ();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70737_aN == this.field_70738_aO) {
                this.damageUntilNextPhase -= lastDamage;
                TwilightForestMod.LOGGER.debug("Urghast Attack successful, {} damage until phase switch.", (Object)Float.valueOf(this.damageUntilNextPhase));
                if (this.damageUntilNextPhase <= 0.0f) {
                    this.switchPhase();
                }
            } else {
                TwilightForestMod.LOGGER.debug("Urghast Attack fail with {} type attack for {} damage", (Object)source.field_76373_n, (Object)Float.valueOf(damage));
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.setInTantrum(false);
        } else {
            this.startTantrum();
        }
        this.resetDamageUntilNextPhase();
    }

    public void resetDamageUntilNextPhase() {
        this.damageUntilNextPhase = 18.0f;
    }

    private void startTantrum() {
        this.setInTantrum(true);
        int rainTime = 6000;
        ServerWorldInfo worldInfo = (ServerWorldInfo)this.field_70170_p.func_73046_m().func_71218_a(World.field_234918_g_).func_72912_H();
        worldInfo.func_230391_a_(0);
        worldInfo.func_76080_g(rainTime);
        worldInfo.func_76090_f(rainTime);
        worldInfo.func_76084_b(true);
        worldInfo.func_76069_a(true);
        this.spawnGhastsAtTraps();
    }

    private void spawnGhastsAtTraps() {
        ArrayList<BlockPos> ghastSpawns = new ArrayList<BlockPos>(this.trapLocations);
        Collections.shuffle(ghastSpawns);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            BlockPos spawnCoord = (BlockPos)ghastSpawns.get(i);
            this.spawnMinionGhastsAt(spawnCoord.func_177958_n(), spawnCoord.func_177956_o(), spawnCoord.func_177952_p());
        }
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.field_70170_p);
        bolt.func_70107_b((double)x, (double)(y + 4), (double)z);
        bolt.func_233623_a_(true);
        this.field_70170_p.func_217376_c((Entity)bolt);
        for (int i = 0; i < tries; ++i) {
            CarminiteGhastlingEntity minion = new CarminiteGhastlingEntity((EntityType<? extends CarminiteGhastlingEntity>)TFEntities.mini_ghast, this.field_70170_p);
            double sx = (double)x + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)rangeXZ;
            double sy = (double)y + this.field_70146_Z.nextDouble() * (double)rangeY;
            double sz = (double)z + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)rangeXZ;
            minion.func_70012_b(sx, sy, sz, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.func_213380_a((IWorld)this.field_70170_p, SpawnReason.MOB_SUMMONED)) {
                this.field_70170_p.func_217376_c((Entity)minion);
                minion.func_70656_aK();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        this.func_213394_dL();
        for (CarminiteGhastlingEntity ghast : this.field_70170_p.func_217357_a(CarminiteGhastlingEntity.class, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
            ghast.func_70656_aK();
            ghast.func_70106_y();
            this.func_70691_i(2.0f);
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            this.scanForTrapsTwice();
            if (this.trapLocations.isEmpty()) {
                this.noTrapMode = true;
            }
        }
        if (this.isInTantrum()) {
            this.func_70624_b(null);
            if (--this.nextTantrumCry <= 0) {
                this.func_184185_a(this.func_184601_bQ(null), this.func_70599_aP(), this.func_70647_i());
                this.nextTantrumCry = 20 + this.field_70146_Z.nextInt(30);
            }
            if (this.field_70173_aa % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
    }

    private void doTantrumDamageEffects() {
        AxisAlignedBB below = this.func_174813_aQ().func_72317_d(0.0, -16.0, 0.0).func_72314_b(0.0, 16.0, 0.0);
        for (PlayerEntity player : this.field_70170_p.func_217357_a(PlayerEntity.class, below)) {
            if (!this.field_70170_p.func_175710_j(player.func_233580_cy_())) continue;
            player.func_70097_a(TFDamageSources.GHAST_TEAR, 3.0f);
        }
        for (CarminiteGhastlingEntity ghast : this.field_70170_p.func_217357_a(CarminiteGhastlingEntity.class, below)) {
            ghast.func_70024_g(0.0, 1.0, 0.0);
        }
    }

    private boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (BlockPos trap : this.trapLocations) {
            AxisAlignedBB aabb = new AxisAlignedBB(trap, trap.func_177982_a(1, 1, 1)).func_72314_b(8.0, 16.0, 8.0);
            List nearbyGhasts = this.field_70170_p.func_217357_a(CarminiteGhastlingEntity.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    @Override
    protected void spitFireball() {
        double offsetX = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
        double offsetY = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f));
        double offsetZ = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
        UrGhastFireballEntity entityFireball = new UrGhastFireballEntity(this.field_70170_p, this, offsetX, offsetY, offsetZ);
        entityFireball.field_92057_e = 1;
        double shotSpawnDistance = 8.5;
        Vector3d lookVec = this.func_70676_i(1.0f);
        entityFireball.func_70107_b(this.func_226277_ct_() + lookVec.field_72450_a * shotSpawnDistance, this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f) + lookVec.field_72448_b * shotSpawnDistance, this.func_226281_cx_() + lookVec.field_72449_c * shotSpawnDistance);
        this.field_70170_p.func_217376_c((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new UrGhastFireballEntity(this.field_70170_p, this, offsetX + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 8.0f), offsetY, offsetZ + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 8.0f));
            entityFireball.field_92057_e = 1;
            entityFireball.func_70107_b(this.func_226277_ct_() + lookVec.field_72450_a * shotSpawnDistance, this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f) + lookVec.field_72448_b * shotSpawnDistance, this.func_226281_cx_() + lookVec.field_72449_c * shotSpawnDistance);
            this.field_70170_p.func_217376_c((Entity)entityFireball);
        }
    }

    private void scanForTrapsTwice() {
        int scanRangeXZ = 48;
        int scanRangeY = 32;
        this.scanForTraps(scanRangeXZ, scanRangeY, this.func_233580_cy_());
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.trapLocations) {
                ax += trapCoords.func_177958_n();
                ay += trapCoords.func_177956_o();
                az += trapCoords.func_177952_p();
            }
            this.scanForTraps(scanRangeXZ, scanRangeY, new BlockPos(ax /= this.trapLocations.size(), ay /= this.trapLocations.size(), az /= this.trapLocations.size()));
        }
    }

    private void scanForTraps(int scanRangeXZ, int scanRangeY, BlockPos pos) {
        for (int sx = -scanRangeXZ; sx <= scanRangeXZ; ++sx) {
            for (int sz = -scanRangeXZ; sz <= scanRangeXZ; ++sz) {
                for (int sy = -scanRangeY; sy <= scanRangeY; ++sy) {
                    BlockPos trapCoords = pos.func_177982_a(sx, sy, sz);
                    if (!this.isTrapAt(trapCoords)) continue;
                    this.trapLocations.add(trapCoords);
                }
            }
        }
    }

    private boolean isTrapAt(BlockPos pos) {
        BlockState inactive = (BlockState)((GhastTrapBlock)TFBlocks.ghast_trap.get()).func_176223_P().func_206870_a((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
        BlockState active = (BlockState)((GhastTrapBlock)TFBlocks.ghast_trap.get()).func_176223_P().func_206870_a((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
        return this.field_70170_p.func_175667_e(pos) && (this.field_70170_p.func_180495_p(pos) == inactive || this.field_70170_p.func_180495_p(pos) == active);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean isInTantrum() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_TANTRUM);
    }

    public void setInTantrum(boolean inTantrum) {
        this.field_70180_af.func_187227_b(DATA_TANTRUM, (Object)inTantrum);
        this.resetDamageUntilNextPhase();
    }

    @Override
    protected float func_70599_aP() {
        return 16.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("inTantrum", this.isInTantrum());
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setInTantrum(compound.func_74767_n("inTantrum"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K) {
            TFTreasure.darktower_boss.generateChest((IWorld)this.field_70170_p, this.findChestCoords(), Direction.NORTH, false);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            TFGenerationSettings.markStructureConquered(this.field_70170_p, this.findChestCoords(), TFFeature.DARK_TOWER);
        }
    }

    private BlockPos findChestCoords() {
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.trapLocations) {
                ax += trapCoords.func_177958_n();
                ay += trapCoords.func_177956_o();
                az += trapCoords.func_177952_p();
            }
            return new BlockPos(ax /= this.trapLocations.size(), (ay /= this.trapLocations.size()) + 2, az /= this.trapLocations.size());
        }
        return new BlockPos((Vector3i)this.func_233580_cy_());
    }

    @Override
    protected boolean shouldAttack(LivingEntity living) {
        return !this.isInTantrum();
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    static class AIWaypointFly
    extends Goal {
        private final UrGhastEntity taskOwner;
        private final List<BlockPos> pointsToVisit;
        private int currentPoint = 0;

        AIWaypointFly(UrGhastEntity ghast) {
            this.taskOwner = ghast;
            this.pointsToVisit = this.createPath();
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController entitymovehelper = this.taskOwner.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.taskOwner.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.taskOwner.func_226278_cu_()) * d1 + (d2 = entitymovehelper.func_179918_f() - this.taskOwner.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.pointsToVisit.isEmpty()) {
                this.pointsToVisit.addAll(this.createPath());
            } else {
                if (this.currentPoint >= this.pointsToVisit.size()) {
                    this.currentPoint = 0;
                    if (!this.taskOwner.checkGhastsAtTraps()) {
                        this.taskOwner.spawnGhastsAtTraps();
                    }
                }
                double x = this.pointsToVisit.get(this.currentPoint).func_177958_n();
                double y = this.pointsToVisit.get(this.currentPoint).func_177956_o() + 20;
                double z = this.pointsToVisit.get(this.currentPoint).func_177952_p();
                this.taskOwner.func_70605_aq().func_75642_a(x, y, z, 1.0);
                ++this.currentPoint;
                this.taskOwner.field_70145_X = false;
            }
        }

        private List<BlockPos> createPath() {
            ArrayList<BlockPos> potentialPoints = new ArrayList<BlockPos>();
            BlockPos pos = new BlockPos((Vector3i)this.taskOwner.func_233580_cy_());
            if (!this.taskOwner.noTrapMode) {
                potentialPoints.addAll(this.taskOwner.trapLocations);
            } else {
                potentialPoints.add(pos.func_177982_a(20, -20, 0));
                potentialPoints.add(pos.func_177982_a(0, -20, -20));
                potentialPoints.add(pos.func_177982_a(-20, -20, 0));
                potentialPoints.add(pos.func_177982_a(0, -20, 20));
            }
            Collections.shuffle(potentialPoints);
            if (this.taskOwner.noTrapMode) {
                potentialPoints.add(pos.func_177979_c(20));
            }
            return potentialPoints;
        }
    }
}

