/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TrophyBlock;
import twilightforest.data.BlockTagGenerator;
import twilightforest.util.PlayerHelper;
import twilightforest.world.TFGenerationSettings;

public class TrophyPedestalBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));

    public TrophyPedestalBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE, WATERLOGGED});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        world.func_175666_e(pos, (Block)this);
        if (world.field_72995_K || ((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() || !this.isTrophyOnTop(world, pos)) {
            return;
        }
        if (TFGenerationSettings.isProgressionEnforced(world)) {
            if (this.areNearbyPlayersEligible(world, pos)) {
                this.doPedestalEffect(world, pos, state);
            }
            this.warnIneligiblePlayers(world, pos);
        } else {
            this.doPedestalEffect(world, pos, state);
        }
        this.rewardNearbyPlayers(world, pos);
    }

    private boolean isTrophyOnTop(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c().func_203417_a(BlockTagGenerator.TROPHIES);
    }

    private void warnIneligiblePlayers(World world, BlockPos pos) {
        for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos).func_186662_g(16.0))) {
            if (this.isPlayerEligible(player)) continue;
            player.func_146105_b((ITextComponent)new TranslationTextComponent("twilightforest.trophy_pedestal.ineligible"), true);
        }
    }

    private boolean areNearbyPlayersEligible(World world, BlockPos pos) {
        for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos).func_186662_g(16.0))) {
            if (!this.isPlayerEligible(player)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerEligible(PlayerEntity player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, TwilightForestMod.prefix("progress_lich"));
    }

    private void doPedestalEffect(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.removeNearbyShields(world, pos);
        world.func_184133_a(null, pos, TFSounds.PEDESTAL_ACTIVATE, SoundCategory.BLOCKS, 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(World world, BlockPos pos) {
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g(16.0))) {
            TFAdvancements.PLACED_TROPHY_ON_PEDESTAL.trigger(player);
        }
    }

    private void removeNearbyShields(World world, BlockPos pos) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    if (world.func_180495_p(pos.func_177982_a(sx, sy, sz)).func_177230_c() != TFBlocks.stronghold_shield.get()) continue;
                    world.func_175655_b(pos.func_177982_a(sx, sy, sz), false);
                }
            }
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)ACTIVE) != false ? super.func_180647_a(state, player, worldIn, pos) : -1.0f;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        Block trophy = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (trophy instanceof TrophyBlock) {
            return ((TrophyBlock)trophy).getComparatorValue();
        }
        return 0;
    }
}

