/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.google.common.base.Preconditions;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.ItemHeartAmulet;
import com.traverse.bhc.common.util.HeartType;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="bhc")
public class HealthModifier {
    public static final UUID HEALTH_MODIFIER_ID = UUID.fromString("caa44aa0-9e6e-4a57-9759-d2f64abfb7d3");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() != RegistryHandler.HEART_AMULET.get()) {
            return;
        }
        final ICurio curio = new ICurio(){

            public void onEquip(String identifier, int index, LivingEntity livingEntity) {
                Optional stackOptional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)RegistryHandler.HEART_AMULET.get(), livingEntity);
                stackOptional.ifPresent(triple -> {
                    if (livingEntity instanceof PlayerEntity) {
                        ItemStack stack = (ItemStack)triple.getRight();
                        HealthModifier.updatePlayerHealth((PlayerEntity)livingEntity, stack, true);
                    }
                });
            }

            public void onUnequip(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    HealthModifier.updatePlayerHealth((PlayerEntity)livingEntity, ItemStack.field_190927_a, false);
                }
            }

            public boolean canRightClickEquip() {
                return false;
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        event.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    public static void updatePlayerHealth(PlayerEntity player, ItemStack stack, boolean addHealth) {
        int i;
        ModifiableAttributeInstance health = player.func_110148_a(Attributes.field_233818_a_);
        float diff = player.func_110138_aP() - player.func_110143_aJ();
        int[] hearts = new int[HeartType.values().length];
        if (addHealth && !stack.func_190926_b()) {
            int[] amuletHearts = ((ItemHeartAmulet)stack.func_77973_b()).getHeartCount(stack);
            Preconditions.checkArgument((amuletHearts.length == HeartType.values().length ? 1 : 0) != 0, (Object)"Array must be same length as enum length!");
            for (i = 0; i < hearts.length; ++i) {
                int n = i;
                hearts[n] = hearts[n] + amuletHearts[i];
            }
        }
        int extraHearts = 0;
        for (i = 0; i < hearts.length; ++i) {
            extraHearts += MathHelper.func_76125_a((int)hearts[i], (int)0, (int)((Integer)ConfigHandler.general.heartStackSize.get() * 2));
        }
        AttributeModifier modifier = health.func_111127_a(HEALTH_MODIFIER_ID);
        if (modifier != null) {
            if (modifier.func_111164_d() == (double)extraHearts) {
                return;
            }
            health.func_111124_b(modifier);
        }
        health.func_233769_c_(new AttributeModifier(HEALTH_MODIFIER_ID, "bhc:extra_hearts", (double)extraHearts, AttributeModifier.Operation.ADDITION));
        float amount = MathHelper.func_76131_a((float)(player.func_110138_aP() - diff), (float)0.0f, (float)player.func_110138_aP());
        if (amount > 0.0f) {
            player.func_70606_j(amount);
        } else {
            player.func_71053_j();
            player.func_174812_G();
        }
    }
}

