/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bhc")
public class DropHandler {
    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || entity instanceof PlayerEntity) {
            return;
        }
        if (!ModList.get().isLoaded("tinkersconstruct") && entity instanceof WitherSkeletonEntity && entity.field_70170_p.field_73012_v.nextDouble() < (Double)ConfigHandler.general.boneDropRate.get()) {
            entity.func_199702_a((IItemProvider)RegistryHandler.WITHER_BONE.get(), 1);
        }
        for (ItemStack stack : DropHandler.getEntityDrops(entity)) {
            entity.func_199702_a((IItemProvider)stack.func_77973_b(), 0);
        }
    }

    public static List<ItemStack> getEntityDrops(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        DropHandler.handleEntry("red", entity, list);
        DropHandler.handleEntry("yellow", entity, list);
        DropHandler.handleEntry("green", entity, list);
        DropHandler.handleEntry("blue", entity, list);
        return list;
    }

    public static void handleEntry(String category, LivingEntity entity, List<ItemStack> items) {
        for (Map.Entry<String, Double> entry : BaubleyHeartCanisters.config.getHeartTypeEntries(category).entrySet()) {
            ItemStack stack = ItemStack.field_190927_a;
            switch (category) {
                case "red": {
                    stack = new ItemStack((IItemProvider)RegistryHandler.RED_HEART.get());
                    break;
                }
                case "yellow": {
                    stack = new ItemStack((IItemProvider)RegistryHandler.YELLOW_HEART.get());
                    break;
                }
                case "green": {
                    stack = new ItemStack((IItemProvider)RegistryHandler.GREEN_HEART.get());
                    break;
                }
                case "blue": {
                    stack = new ItemStack((IItemProvider)RegistryHandler.BLUE_HEART.get());
                }
            }
            if (entry.getKey().equals(entity.func_70022_Q())) {
                DropHandler.addWithPercent(items, stack, entry.getValue());
                continue;
            }
            switch (entry.getKey()) {
                case "hostile": {
                    if (!(entity instanceof IMob) || !entity.func_184222_aU()) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "boss": {
                    if (entity.func_184222_aU() || entity instanceof EnderDragonEntity) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "dragon": {
                    if (!(entity instanceof EnderDragonEntity)) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                }
            }
        }
    }

    public static void addWithPercent(List<ItemStack> list, ItemStack stack, double percentage) {
        Random random = new Random();
        int percent = (int)(percentage * 100.0);
        if (random.nextInt(100) < percent) {
            list.add(stack);
        }
    }
}

