/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.container;

import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.BaseHeartCanister;
import com.traverse.bhc.common.items.ItemHeartAmulet;
import com.traverse.bhc.common.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class HeartAmuletContainer
extends Container {
    public static final String HEART_AMOUNT = "heart_amount";
    public ItemStackHandler itemStackHandler;

    public HeartAmuletContainer(int windowId, PlayerInventory playerInventory, ItemStack stack) {
        super((ContainerType)RegistryHandler.HEART_AMUlET_CONTAINER.get(), windowId);
        int row;
        this.itemStackHandler = InventoryUtil.createVirtualInventory(4, stack);
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 0, 80, 9));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 1, 53, 33));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 2, 107, 33));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 3, 80, 57));
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            if (row == this.getSlotFor(playerInventory, stack)) {
                this.func_75146_a(new LockedSlot((IInventory)playerInventory, row, x, y));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)playerInventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 66;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9, x, y));
            }
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        Hand hand = ItemHeartAmulet.getHandForAmulet(playerIn);
        if (hand != null) {
            InventoryUtil.serializeInventory(this.itemStackHandler, playerIn.func_184586_b(hand));
        }
        CompoundNBT nbt = playerIn.func_184586_b(hand).func_77978_p();
        int[] hearts = new int[this.itemStackHandler.getSlots()];
        for (int i = 0; i < hearts.length; ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            hearts[i] = stack.func_190916_E() * 2;
        }
        nbt.func_74783_a(HEART_AMOUNT, hearts);
        playerIn.func_184586_b(hand).func_77982_d(nbt);
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index < this.itemStackHandler.getSlots()) {
                if (!this.func_75135_a(slotStack, this.itemStackHandler.getSlots(), this.field_75151_b.size(), true)) {
                    // empty if block
                }
                return ItemStack.field_190927_a;
            }
            if (!this.func_75135_a(slotStack, 0, this.itemStackHandler.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public int getSlotFor(PlayerInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
            if (((ItemStack)inventory.field_70462_a.get(i)).func_190926_b() || !this.stackEqualExact(stack, (ItemStack)inventory.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static class LockedSlot
    extends Slot {
        public LockedSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity playerIn) {
            return false;
        }
    }

    private static class SlotPendant
    extends SlotItemHandler {
        public SlotPendant(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return super.func_75214_a(stack) && stack.func_77973_b() instanceof BaseHeartCanister && ((BaseHeartCanister)stack.func_77973_b()).type.ordinal() == this.getSlotIndex();
        }

        public int func_75219_a() {
            return (Integer)ConfigHandler.general.heartStackSize.get();
        }
    }
}

