/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.vec.Vector3;
import net.minecraft.util.Direction;

public class VectorUtils {
    public static Vector3 calculateNormal(Vector3 ... vertices) {
        Vector3 diff1 = vertices[1].copy().subtract(vertices[0]);
        Vector3 diff2 = vertices[2].copy().subtract(vertices[0]);
        return diff1.crossProduct(diff2).normalize().copy();
    }

    public static int findSide(Vector3 normal) {
        if (normal.y <= -0.99) {
            return 0;
        }
        if (normal.y >= 0.99) {
            return 1;
        }
        if (normal.z <= -0.99) {
            return 2;
        }
        if (normal.z >= 0.99) {
            return 3;
        }
        if (normal.x <= -0.99) {
            return 4;
        }
        if (normal.x >= 0.99) {
            return 5;
        }
        return -1;
    }

    public static Direction calcNormalSide(Vector3 normal) {
        if (normal.y <= -0.99) {
            return Direction.DOWN;
        }
        if (normal.y >= 0.99) {
            return Direction.UP;
        }
        if (normal.z <= -0.99) {
            return Direction.NORTH;
        }
        if (normal.z >= 0.99) {
            return Direction.SOUTH;
        }
        if (normal.x <= -0.99) {
            return Direction.WEST;
        }
        if (normal.x >= 0.99) {
            return Direction.EAST;
        }
        return null;
    }
}

