/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.Perspective;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import com.teamderpy.shouldersurfing.util.ShoulderSurfingHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class KeyHandler {
    private static final String KEY_CATEGORY = "Shoulder Surfing";
    public static final KeyBinding KEYBIND_CAMERA_LEFT = new KeyBinding("Camera left", 263, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_CAMERA_RIGHT = new KeyBinding("Camera right", 262, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_CAMERA_IN = new KeyBinding("Camera closer", 265, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_CAMERA_OUT = new KeyBinding("Camera farther", 264, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_CAMERA_UP = new KeyBinding("Camera up", 266, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_CAMERA_DOWN = new KeyBinding("Camera down", 267, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_SWAP_SHOULDER = new KeyBinding("Swap shoulder", 79, "Shoulder Surfing");
    public static final KeyBinding KEYBIND_TOGGLE_SHOULDER_SURFING = new KeyBinding("Toggle perspective", InputMappings.field_197958_a.func_197937_c(), "Shoulder Surfing");

    @SubscribeEvent
    public static void keyInputEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r == null) {
            if (KEYBIND_TOGGLE_SHOULDER_SURFING.func_151470_d()) {
                if (ShoulderState.doShoulderSurfing()) {
                    ShoulderSurfingHelper.setPerspective(Perspective.FIRST_PERSON);
                } else if (Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
                    ShoulderSurfingHelper.setPerspective(Perspective.SHOULDER_SURFING);
                }
            }
            if (ShoulderState.doShoulderSurfing()) {
                if (KEYBIND_CAMERA_LEFT.func_151470_d()) {
                    Config.CLIENT.adjustCameraLeft();
                }
                if (KEYBIND_CAMERA_RIGHT.func_151470_d()) {
                    Config.CLIENT.adjustCameraRight();
                }
                if (KEYBIND_CAMERA_OUT.func_151470_d()) {
                    Config.CLIENT.adjustCameraOut();
                }
                if (KEYBIND_CAMERA_IN.func_151470_d()) {
                    Config.CLIENT.adjustCameraIn();
                }
                if (KEYBIND_CAMERA_UP.func_151470_d()) {
                    Config.CLIENT.adjustCameraUp();
                }
                if (KEYBIND_CAMERA_DOWN.func_151470_d()) {
                    Config.CLIENT.adjustCameraDown();
                }
                if (KEYBIND_SWAP_SHOULDER.func_151470_d()) {
                    Config.CLIENT.swapShoulder();
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_151457_aa.func_151468_f()) {
                Perspective perspective = Perspective.current();
                Perspective next = perspective.next();
                ShoulderSurfingHelper.setPerspective(next);
                boolean firstPerson = next.getPointOfView().func_243192_a();
                if (perspective.getPointOfView().func_243192_a() != firstPerson) {
                    Minecraft.func_71410_x().field_71460_t.func_175066_a(firstPerson ? Minecraft.func_71410_x().func_175606_aa() : null);
                }
                if (Config.CLIENT.doRememberLastPerspective()) {
                    Config.CLIENT.setDefaultPerspective(next);
                }
            }
        }
    }
}

