/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.Perspective;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import com.teamderpy.shouldersurfing.util.ShoulderSurfingHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (!Perspective.FIRST_PERSON.equals((Object)Perspective.current())) {
                ShoulderState.setSwitchPerspective(false);
            }
            ShoulderState.setAiming(ShoulderSurfingHelper.isHoldingSpecialItem());
            if (ShoulderState.isAiming() && Config.CLIENT.getCrosshairType().doSwitchPerspective() && ShoulderState.doShoulderSurfing()) {
                ShoulderSurfingHelper.setPerspective(Perspective.FIRST_PERSON);
                ShoulderState.setSwitchPerspective(true);
            } else if (!ShoulderState.isAiming() && Perspective.FIRST_PERSON.equals((Object)Perspective.current()) && ShoulderState.doSwitchPerspective()) {
                ShoulderSurfingHelper.setPerspective(Perspective.SHOULDER_SURFING);
            }
        }
    }

    @SubscribeEvent
    public static void preRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (event.isCancelable() && event.getPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71462_r == null && ShoulderState.getCameraDistance() < 0.8 && Config.CLIENT.keepCameraOutOfHead() && ShoulderState.doShoulderSurfing()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            if (ShoulderState.getProjected() != null) {
                MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
                float scale = (float)mainWindow.func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()) * ShoulderSurfingHelper.getShadersResMul();
                Vec2f window = new Vec2f(mainWindow.func_198107_o(), mainWindow.func_198087_p());
                Vec2f center = window.scale(scale).divide(2.0f);
                Vec2f projectedOffset = ShoulderState.getProjected().subtract(center).divide(scale);
                Vec2f lastTranslation = ShoulderState.getLastTranslation();
                Vec2f interpolated = projectedOffset.subtract(lastTranslation).scale(event.getPartialTicks());
                ShoulderState.setTranslation(ShoulderState.getLastTranslation().add(interpolated));
            }
            if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderState.doShoulderSurfing()) {
                event.getMatrixStack().func_227860_a_();
                event.getMatrixStack().func_227866_c_().func_227870_a_().func_226597_a_(new Vector3f(ShoulderState.getTranslation().getX(), -ShoulderState.getTranslation().getY(), 0.0f));
                ShoulderState.setLastTranslation(ShoulderState.getTranslation());
            } else {
                ShoulderState.setLastTranslation(Vec2f.ZERO);
            }
        }
    }

    @SubscribeEvent
    public static void postRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Config.CLIENT.getCrosshairType().isDynamic() && ShoulderState.doShoulderSurfing()) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public static void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (ShoulderState.doShoulderSurfing() && world != null) {
            ActiveRenderInfo info = event.getInfo();
            double x = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70169_q, (double)info.func_216773_g().func_226277_ct_());
            double y = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70167_r, (double)info.func_216773_g().func_226278_cu_()) + MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.field_216802_n, (double)info.field_216801_m);
            double z = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70166_s, (double)info.func_216773_g().func_226281_cx_());
            info.func_216775_b(x, y, z);
            Vector3d offset = new Vector3d(-Config.CLIENT.getOffsetZ(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetX());
            double distance = ShoulderSurfingHelper.cameraDistance(info, (World)world, info.func_216779_a(offset.func_72433_c()));
            Vector3d scaled = offset.func_72432_b().func_186678_a(distance);
            ShoulderState.setCameraDistance(distance);
            info.func_216782_a(scaled.field_72450_a, scaled.field_72448_b, scaled.field_72449_c);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderWorldLastEvent event) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        PlayerController controller = Minecraft.func_71410_x().field_71442_b;
        if (ShoulderState.doShoulderSurfing()) {
            double playerReach = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            RayTraceResult result = ShoulderSurfingHelper.traceFromEyes(info.func_216773_g(), controller, playerReach, event.getPartialTicks());
            Vector3d position = result.func_216347_e().func_178788_d(info.func_216785_c());
            Matrix4f modelView = event.getMatrixStack().func_227866_c_().func_227870_a_();
            Matrix4f projection = event.getProjectionMatrix();
            ShoulderState.setProjected(ShoulderSurfingHelper.project2D(position, modelView, projection));
        }
    }
}

