/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftblibrary.math.XZ;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.IChunk;

public class ReloadChunkTask
implements MapTask {
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");
    public static long debugLastTime = 0L;
    public final World level;
    public final IChunk chunkAccess;
    public final ChunkPos pos;
    public final IntOpenHashSet blockPosSet;

    public ReloadChunkTask(World w, IChunk ca, ChunkPos p, IntOpenHashSet s) {
        this.level = w;
        this.chunkAccess = ca;
        this.pos = p;
        this.blockPosSet = s;
    }

    @Override
    public void runMapTask(MapManager manager) throws Exception {
        long startTime = System.nanoTime();
        RegistryKey dimId = this.level.func_234923_W_();
        MapChunk mapChunk = manager.getDimension((RegistryKey<World>)dimId).getRegion(XZ.regionFromChunk((ChunkPos)this.pos)).getDataBlocking().getChunk(XZ.of((ChunkPos)this.pos));
        MapRegionData data = mapChunk.region.getDataBlocking();
        MutableRegistry biomes = this.level.func_241828_r().func_243612_b(Registry.field_239720_u_);
        BiomeContainer biomeContainer = this.chunkAccess.func_225549_i_();
        int topY = this.level.func_234938_ad_() + 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int blockX = this.pos.func_180334_c();
        int blockZ = this.pos.func_180333_d();
        boolean changed = false;
        boolean[] flags = new boolean[1];
        IntIterator intIterator = this.blockPosSet.iterator();
        while (intIterator.hasNext()) {
            Biome biome;
            int wi = (Integer)intIterator.next();
            int wx = wi % 16;
            int wz = wi / 16;
            blockPos.func_181079_c(blockX + wx, topY, blockZ + wz);
            int height = MathHelper.func_76125_a((int)MapChunk.getHeight(this.chunkAccess, blockPos, flags).func_177956_o(), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            blockPos.func_185336_p(height);
            BlockState state = this.chunkAccess.func_180495_p((BlockPos)blockPos);
            int ax = mapChunk.pos.x * 16 + wx;
            int az = mapChunk.pos.z * 16 + wz;
            int index = ax + az * 512;
            int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
            int blockIndex0 = data.getBlockIndex(index);
            int height0 = data.height[index] & 0xFFFF;
            int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
            waterLightAndBiome |= flags[0] ? 32768 : 0;
            waterLightAndBiome |= (this.level.func_226658_a_(LightType.BLOCK, blockPos.func_177984_a()) & 0xF) << 11;
            ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
            int blockIndex = manager.getBlockColorIndex(id == null ? AIR : id);
            if (height0 != height || waterLightAndBiome0 == 0) {
                biome = biomeContainer == null ? this.level.func_226691_t_((BlockPos)blockPos) : biomeContainer.func_225526_b_(blockPos.func_177958_n() >> 2, blockPos.func_177956_o() >> 2, blockPos.func_177952_p() >> 2);
                waterLightAndBiome &= 0xF800;
                waterLightAndBiome |= manager.getBiomeColorIndex((MutableRegistry<Biome>)biomes, biome, biome) & 0x7FF;
            } else {
                biome = null;
            }
            if (height0 != height) {
                data.height[index] = (short)height;
                changed = true;
            }
            if (waterLightAndBiome0 != waterLightAndBiome) {
                data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                if (biome != null && (waterLightAndBiome0 & 0x7FF) != (waterLightAndBiome & 0x7FF)) {
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | BiomeColors.func_228361_b_((IBlockDisplayReader)this.level, (BlockPos)blockPos) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | BiomeColors.func_228358_a_((IBlockDisplayReader)this.level, (BlockPos)blockPos) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | BiomeColors.func_228363_c_((IBlockDisplayReader)this.level, (BlockPos)blockPos) & 0xFFFFFF;
                }
                changed = true;
            }
            if (blockIndex0 != blockIndex) {
                data.setBlockIndex(index, blockIndex);
                changed = true;
            }
            flags[0] = false;
        }
        if (changed) {
            mapChunk.modified = System.currentTimeMillis();
            mapChunk.region.update(true);
        }
        debugLastTime = System.nanoTime() - startTime;
    }

    public String toString() {
        return "ReloadChunkTask@" + this.pos;
    }
}

