/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.core.ChunkMapFTBC;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.LoadedChunkViewPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.ToIntBiFunction;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;

public class FTBChunksCommands {
    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbchunks").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"load").executes(context -> FTBChunksCommands.load((CommandSource)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.load((CommandSource)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload").executes(context -> FTBChunksCommands.unload((CommandSource)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unload((CommandSource)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim_all").executes(context -> FTBChunksCommands.unclaimAll((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unclaimAll)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload_all").executes(context -> FTBChunksCommands.unloadAll((CommandSource)context.getSource(), FTBChunksCommands.selfTeam((CommandSource)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unloadAll)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos((World)((CommandSource)context.getSource()).func_197023_e(), new BlockPos(((CommandSource)context.getSource()).func_197036_d()))))).then(Commands.func_197056_a((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos((World)((CommandSource)context.getSource()).func_197023_e(), new BlockPos(IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), 0, IntegerArgumentType.getInteger((CommandContext)context, (String)"z")))))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos(FTBChunksCommands.getDimArg((CommandContext<CommandSource>)context).func_234923_W_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"admin").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"bypass_protection").executes(context -> FTBChunksCommands.bypassProtection(((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"extra_claim_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"get").executes(context -> FTBChunksCommands.getExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.addExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))))).then(Commands.func_197057_a((String)"extra_force_load_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"get").executes(context -> FTBChunksCommands.getExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.addExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))))).then(Commands.func_197057_a((String)"claim_as").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSource>)context), (World)((CommandSource)context.getSource()).func_197023_e()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSource>)context), (World)FTBChunksCommands.getDimArg((CommandContext<CommandSource>)context))))))))).then(Commands.func_197057_a((String)"unclaim_as").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSource>)context), (World)((CommandSource)context.getSource()).func_197023_e()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSource>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSource>)context), (World)FTBChunksCommands.getDimArg((CommandContext<CommandSource>)context))))))))).then(Commands.func_197057_a((String)"unclaim_everything").executes(context -> FTBChunksCommands.unclaimEverything((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"unload_everything").executes(context -> FTBChunksCommands.unloadEverything((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"view_loaded_chunks").executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e()))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e()))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSource)context.getSource(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSource)context.getSource(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"block_color").requires(source -> source.func_197028_i().func_71264_H())).executes(context -> FTBChunks.PROXY.blockColor())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunks").redirect((CommandNode)command));
    }

    private static int bypassProtection(ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.bypassProtection = !data.bypassProtection;
        return 1;
    }

    private static void forEachChunk(CommandSource source, int r, ChunkCallback callback) throws CommandSyntaxException {
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayerEntity)source.func_197035_h());
        FTBChunksCommands.forEachChunk(team, (World)source.func_197023_e(), FTBChunksCommands.toColumn(source.func_197036_d()), r, callback);
    }

    private static void forEachChunk(Team team, World level, ColumnPos anchor, int r, ChunkCallback callback) throws CommandSyntaxException {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        RegistryKey dimId = level.func_234923_W_();
        int ox = MathHelper.func_76141_d((float)anchor.field_219439_a) >> 4;
        int oz = MathHelper.func_76141_d((float)anchor.field_219440_b) >> 4;
        ArrayList<ChunkDimPos> list = new ArrayList<ChunkDimPos>();
        for (int z = -(r >>= 4); z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                list.add(new ChunkDimPos(dimId, ox + x, oz + z));
            }
        }
        list.sort(Comparator.comparingDouble(o -> MathUtils.distSq((double)ox, (double)oz, (double)o.x, (double)o.z)));
        for (ChunkDimPos pos : list) {
            callback.accept(data, pos);
        }
    }

    private static int claim(CommandSource source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.claim(source, team, r, FTBChunksCommands.toColumn(source.func_197036_d()), (World)source.func_197023_e());
    }

    private static int claim(CommandSource source, Team team, int r, ColumnPos anchor, World level) throws CommandSyntaxException {
        int[] success = new int[1];
        long now = System.currentTimeMillis();
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            ClaimResult result = data.claim(source, pos, false);
            if (result.isSuccess()) {
                result.setClaimedTime(now);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Claimed " + success[0] + " chunks!"), false);
        ChunkDimPos origin = new ChunkDimPos(level.func_234923_W_(), anchor.field_219439_a >> 4, anchor.field_219440_b >> 4);
        FTBChunks.LOGGER.info(source.func_197037_c() + " claimed " + success[0] + " chunks around " + origin + "for team " + team.getDisplayName());
        return success[0];
    }

    private static int unclaim(CommandSource source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.unclaim(source, team, r, FTBChunksCommands.toColumn(source.func_197036_d()), (World)source.func_197023_e());
    }

    private static int unclaim(CommandSource source, Team team, int r, ColumnPos anchor, World level) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            if (data.unclaim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unclaimed " + success[0] + " chunks!"), false);
        ChunkDimPos origin = new ChunkDimPos(level.func_234923_W_(), anchor.field_219439_a >> 4, anchor.field_219440_b >> 4);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unclaimed " + success[0] + " chunks around " + origin + "for team " + team.getDisplayName());
        return success[0];
    }

    private static int load(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        long now = System.currentTimeMillis();
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.load(source, pos, false);
            if (result.isSuccess()) {
                result.setForceLoadedTime(now);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Loaded " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " loaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int unload(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            if (data.unload(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unloaded " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unloaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int unclaimAll(CommandSource source, Team team) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        for (ClaimedChunk c : new ArrayList<ClaimedChunk>(data.getClaimedChunks())) {
            data.unclaim(source, c.getPos(), false);
        }
        data.save();
        return 1;
    }

    private static int unloadAll(CommandSource source, Team team) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        for (ClaimedChunk c : new ArrayList<ClaimedChunk>(data.getClaimedChunks())) {
            data.unload(source, c.getPos(), false);
        }
        data.save();
        return 1;
    }

    private static int info(CommandSource source, ChunkDimPos pos) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Location: " + pos), true);
        ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(pos);
        if (chunk == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Chunk not claimed!"), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Owner: ").func_230529_a_(chunk.getTeamData().getTeam().getColoredName()).func_240702_b_(" / " + UUIDTypeAdapter.fromUUID((UUID)chunk.getTeamData().getTeamId())), true);
        if (source.func_197034_c(2)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Force Loaded: " + chunk.isForceLoaded()), true);
        }
        return 1;
    }

    private static int getExtraClaimChunks(CommandSource source, ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int setExtraClaimChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraClaimChunks = Math.max(0, i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int addExtraClaimChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraClaimChunks = Math.max(0, data.extraClaimChunks + i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int getExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int setExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraForceLoadChunks = Math.max(0, i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int addExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraForceLoadChunks = Math.max(0, data.extraForceLoadChunks + i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int unclaimEverything(CommandSource source) {
        for (ClaimedChunk c : new ArrayList<ClaimedChunk>(FTBChunksAPI.getManager().getAllClaimedChunks())) {
            c.teamData.unclaim(source, c.getPos(), false);
            c.teamData.save();
        }
        return 1;
    }

    private static int unloadEverything(CommandSource source) {
        for (ClaimedChunk c : new ArrayList<ClaimedChunk>(FTBChunksAPI.getManager().getAllClaimedChunks())) {
            c.teamData.unload(source, c.getPos(), false);
            c.teamData.save();
        }
        return 1;
    }

    private static int viewLoadedChunks(CommandSource source, ServerWorld level) throws CommandSyntaxException {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        for (ChunkHolder holder : ((ChunkMapFTBC)level.func_72863_F().field_217237_a).getChunksFTBC().values()) {
            chunks.add(holder.func_219277_h());
        }
        source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Chunks Loaded: %d. Check the map to see loaded chunks", chunks.size())), false);
        new LoadedChunkViewPacket((RegistryKey<World>)level.func_234923_W_(), chunks).sendTo(source.func_197035_h());
        return 1;
    }

    private static int resetLoadedChunks(CommandSource source, ServerWorld level) throws CommandSyntaxException {
        new LoadedChunkViewPacket((RegistryKey<World>)level.func_234923_W_(), Collections.emptyList()).sendTo(source.func_197035_h());
        return 1;
    }

    private static RequiredArgumentBuilder<CommandSource, Integer> radiusArg() {
        return Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)512));
    }

    private static int getRadiusArg(CommandContext<CommandSource> context) {
        return IntegerArgumentType.getInteger(context, (String)"radius_in_blocks");
    }

    private static RequiredArgumentBuilder<CommandSource, ILocationArgument> anchorArg() {
        return Commands.func_197056_a((String)"anchor", (ArgumentType)new ColumnPosArgument());
    }

    private static ColumnPos getAnchorArg(CommandContext<CommandSource> context) {
        return ColumnPosArgument.func_218101_a(context, (String)"anchor");
    }

    private static RequiredArgumentBuilder<CommandSource, ResourceLocation> dimArg() {
        return Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a());
    }

    private static ServerWorld getDimArg(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return DimensionArgument.func_212592_a(context, (String)"dimension");
    }

    private static RequiredArgumentBuilder<CommandSource, TeamArgumentProvider> forTeam(ToIntBiFunction<CommandSource, Team> callback) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"team", (ArgumentType)TeamArgument.create()).requires(source -> source.func_197034_c(2))).executes(context -> callback.applyAsInt((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")));
    }

    private static ColumnPos toColumn(Vector3d pos) {
        return new ColumnPos(new BlockPos(pos));
    }

    private static Team selfTeam(CommandSource source) throws CommandSyntaxException {
        return FTBTeamsAPI.getPlayerTeam((ServerPlayerEntity)source.func_197035_h());
    }

    private static interface ChunkCallback {
        public void accept(FTBChunksTeamData var1, ChunkDimPos var2) throws CommandSyntaxException;
    }
}

