/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.IntPredicate;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class MulticonnectCompatibility {
    private static final boolean MULTICONNECT_LOADED = ModLoaderUtils.isModLoaded("multiconnect");
    public static final MulticonnectCompatibility INSTANCE = new MulticonnectCompatibility();
    private final Optional<Class<?>> connectionInfoClass;
    private final Optional<Field> protocolVersion;
    private boolean enabled = MULTICONNECT_LOADED;

    public MulticonnectCompatibility() {
        if (this.enabled) {
            this.connectionInfoClass = ReflectionUtils.getClass("net.earthcomputer.multiconnect.impl.ConnectionInfo");
            this.protocolVersion = ReflectionUtils.getField(this.connectionInfoClass, "protocolVersion");
        } else {
            this.connectionInfoClass = Optional.empty();
            this.protocolVersion = Optional.empty();
        }
    }

    public <T> T getProtocolDependantValue(IntPredicate protocolPredicate, T trueValue, T defaultValue) {
        if (this.enabled) {
            return (T)this.protocolVersion.map(f -> {
                try {
                    return protocolPredicate.test((Integer)f.get(null)) ? trueValue : defaultValue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return defaultValue;
                }
            }).orElse(defaultValue);
        }
        return defaultValue;
    }
}

