/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class IdentityCompatibility {
    private static final boolean IDENTITY_LOADED = ModLoaderUtils.isModLoaded("identity");
    public static final IdentityCompatibility INSTANCE = new IdentityCompatibility();
    private final Optional<Class<?>> componentsClass;
    private final Optional<Class<?>> componentTypeClass;
    private final Optional<Class<?>> identityComponentClass;
    private final Optional<Object> currentIdentity;
    private final Optional<Method> getComponent;
    private final Optional<Method> getIdentity;
    private boolean enabled = IDENTITY_LOADED;

    public IdentityCompatibility() {
        if (this.enabled) {
            this.componentsClass = ReflectionUtils.getClass("draylar.identity.registry.Components");
            this.componentTypeClass = ReflectionUtils.getClass("nerdhub.cardinal.components.api.ComponentType");
            this.identityComponentClass = ReflectionUtils.getClass("draylar.identity.cca.IdentityComponent");
            this.currentIdentity = ReflectionUtils.getField(this.componentsClass, "CURRENT_IDENTITY").map(f -> {
                try {
                    return f.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return Optional.empty();
                }
            });
            this.getComponent = ReflectionUtils.getMethod(this.componentTypeClass, "get", Object.class);
            this.getIdentity = ReflectionUtils.getMethod(this.identityComponentClass, "getIdentity", new Class[0]);
        } else {
            this.componentsClass = Optional.empty();
            this.componentTypeClass = Optional.empty();
            this.identityComponentClass = Optional.empty();
            this.currentIdentity = Optional.empty();
            this.getComponent = Optional.empty();
            this.getIdentity = Optional.empty();
        }
    }

    public LivingEntity getIdentity(PlayerEntity entity) {
        if (this.enabled) {
            return this.currentIdentity.flatMap(t -> this.getComponent.flatMap(c -> this.getIdentity.map(m -> {
                try {
                    return (LivingEntity)m.invoke(c.invoke(t, entity), new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }))).orElse(null);
        }
        return null;
    }
}

