/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.util.I18nUtils;

public class ScaleCommand {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat SCALE_FORMAT = new DecimalFormat("0");

    public static void register(CommandDispatcher<CommandSource> commandDispatcher, boolean dedicated) {
        ScaleCommand.register(commandDispatcher);
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"scale").requires(commandSource -> commandSource.func_197034_c(2));
        ScaleCommand.registerOperation((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerRandomize((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerGet((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerCompute((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerReset((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerModifier((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerDelay((LiteralArgumentBuilder<CommandSource>)builder);
        ScaleCommand.registerPersist((LiteralArgumentBuilder<CommandSource>)builder);
        commandDispatcher.register(builder);
    }

    private static LiteralArgumentBuilder<CommandSource> registerOperation(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"operation", (ArgumentType)ScaleOperationArgumentType.operation()).then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "operation");
                data.setTargetScale(operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "operation");
            data.setTargetScale(operation.apply(data.getTargetScale(), scale));
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "operation");
                data.setTargetScale(operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "operation");
            data.setTargetScale(operation.apply(data.getTargetScale(), scale));
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerRandomize(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"randomize").then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"minOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(Commands.func_197056_a((String)"minValue", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.func_197056_a((String)"maxOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"maxValue", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                float target = data.getTargetScale();
                float min = minOperation.apply(target, minValue);
                float max = maxOperation.apply(target, maxValue);
                if (max < min) {
                    float temp = min;
                    min = max;
                    max = temp;
                }
                data.setTargetScale(min + RANDOM.nextFloat() * (max - min));
            }
            return 1;
        }))).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<CommandSource>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            float target = data.getTargetScale();
            float min = minOperation.apply(target, minValue);
            float max = maxOperation.apply(target, maxValue);
            if (max < min) {
                float temp = min;
                min = max;
                max = temp;
            }
            data.setTargetScale(min + RANDOM.nextFloat() * (max - min));
            return 1;
        })))))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerGet(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getBaseScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getBaseScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getBaseScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getBaseScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerCompute(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"compute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(Commands.func_197056_a((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            float scale = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getScale();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.scaleText(scale), false);
            return (int)scale;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerReset(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            Boolean persist = data.getPersistence();
            data.resetScale();
            data.setPersistence(persist);
            return 1;
        }))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    Boolean persist = data.getPersistence();
                    data.resetScale();
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerModifier(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"modifier").then(Commands.func_197057_a((String)"get").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity"));
            String modifierString = String.join((CharSequence)", ", data.getBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.modifierText(modifierString), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            String modifierString = String.join((CharSequence)", ", type.getDefaultBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.modifierText(modifierString), false);
            return 1;
        })))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSource>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().add(modifier);
                data.onUpdate();
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSource>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.getBaseValueModifiers().add(modifier);
            data.onUpdate();
            return 1;
        }))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSource>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().remove(modifier);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<CommandSource>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.getBaseValueModifiers().remove(modifier);
            return 1;
        }))))).then(Commands.func_197057_a((String)"reset").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
                baseValueModifiers.clear();
                baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
            baseValueModifiers.clear();
            baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            return 1;
        }))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerDelay(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"delay").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleData data = ScaleTypes.BASE.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            int ticks = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getScaleTickDelay();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            int ticks = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getScaleTickDelay();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getScaleTickDelay();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getScaleTickDelay();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.delayText(ticks), false);
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerPersist(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"persist").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.setPersistence(persist);
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
                data.setPersistence(persist);
            }
            return 1;
        })))).then(Commands.func_197057_a((String)"get").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            Boolean persist = type.getScaleData(EntityArgument.func_197088_a((CommandContext)context, (String)"entity")).getPersistence();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.persistenceText(persist, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            Boolean persist = type.getScaleData(((CommandSource)context.getSource()).func_197027_g()).getPersistence();
            ((CommandSource)context.getSource()).func_197030_a(ScaleCommand.persistenceText(persist, type), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(null);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<CommandSource>)context, "scale_type");
            ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
            data.setPersistence(null);
            return 1;
        }))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> {
            for (Entity e : EntityArgument.func_197097_b((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(null);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((CommandSource)context.getSource()).func_197027_g());
                data.setPersistence(null);
            }
            return 1;
        })));
        return builder;
    }

    private static ITextComponent scaleText(float scale) {
        return I18nUtils.translate("commands.pehkui.scale.get.message", "Scale: %s", ScaleCommand.format(scale));
    }

    private static ITextComponent scaleText(float scale, int multiplied) {
        return I18nUtils.translate("commands.pehkui.scale.get.factor.message", "Scale: %s (%d)", ScaleCommand.format(scale), multiplied);
    }

    private static ITextComponent modifierText(String modifierString) {
        return I18nUtils.translate("commands.pehkui.scale.modifier.get.message", "%s", modifierString.isEmpty() ? "N/A" : modifierString);
    }

    private static ITextComponent delayText(int ticks) {
        return I18nUtils.translate("commands.pehkui.scale.delay.get.message", "Delay: %d ticks", ticks);
    }

    private static ITextComponent persistenceText(Boolean persist, ScaleType type) {
        String unlocalized = "commands.pehkui.scale.persist." + (persist != null ? persist : "default." + type.getDefaultPersistence());
        String message = "Persistent: " + (persist == null ? "default (" + type.getDefaultPersistence() + ")" : persist);
        return I18nUtils.translate(unlocalized, message);
    }

    private static String format(float scale) {
        return SCALE_FORMAT.format(scale);
    }

    static {
        SCALE_FORMAT.setMaximumFractionDigits(340);
    }
}

