/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    final int id;
    final int quantity;
    final ResourceLocation[] typeIds;
    CompoundNBT[] nbt = null;
    ScaleData[] scaleData = null;

    public ScalePacket(Entity entity, Collection<ScaleData> scales) {
        this.id = entity.func_145782_y();
        this.quantity = scales.size();
        this.scaleData = scales.toArray(new ScaleData[this.quantity]);
        this.typeIds = new ResourceLocation[this.quantity];
        for (int i = 0; i < this.quantity; ++i) {
            this.typeIds[i] = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, this.scaleData[i].getScaleType());
        }
    }

    protected ScalePacket(PacketBuffer buf) {
        this.id = buf.func_150792_a();
        this.quantity = buf.readInt();
        this.typeIds = new ResourceLocation[this.quantity];
        this.nbt = new CompoundNBT[this.quantity];
        for (int i = 0; i < this.quantity; ++i) {
            this.typeIds[i] = buf.func_192575_l();
            this.nbt[i] = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
        }
    }

    public static void handle(ScalePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.func_71410_x();
            Entity entity = client.field_71441_e.func_73045_a(msg.id);
            if (entity != null) {
                for (int i = 0; i < msg.quantity; ++i) {
                    if (!ScaleRegistries.SCALE_TYPES.containsKey((Object)msg.typeIds[i])) continue;
                    ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, msg.typeIds[i]).getScaleData(entity).readNbt(msg.nbt[i]);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.id);
        buf.writeInt(this.quantity);
        for (int i = 0; i < this.quantity; ++i) {
            buf.func_192572_a(this.typeIds[i]);
            this.scaleData[i].toPacket(buf);
        }
    }
}

