/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class DebugPacket {
    private final Type type;

    public DebugPacket(Type type) {
        this.type = type;
    }

    protected DebugPacket(PacketBuffer buf) {
        Type read;
        try {
            read = (Type)buf.func_179257_a(Type.class);
        }
        catch (Exception e) {
            read = null;
        }
        this.type = read;
    }

    public static void handle(DebugPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Type type = msg.type;
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.func_71410_x();
            switch (type) {
                case MIXIN_AUDIT: {
                    client.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Starting Mixin environment audit (client)..."), false);
                    MixinEnvironment.getCurrentEnvironment().audit();
                    client.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Mixin environment audit (client) complete!"), false);
                    break;
                }
                case GARBAGE_COLLECT: {
                    System.gc();
                    break;
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public void encode(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.type);
    }

    public static enum Type {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

