/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.mixin.EntityMixin;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin {
    @ModifyArg(method={"getEyeHeight"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getActiveEyeHeight(Lnet/minecraft/entity/EntityPose;Lnet/minecraft/entity/EntityDimensions;)F"))
    private EntitySize onGetEyeHeightDimensionsProxy(EntitySize dimensions) {
        return dimensions.func_220313_a(1.0f / ScaleUtils.getEyeHeightScale((Entity)this));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=1.0f, ordinal=0)})
    private float travelModifyFallDistance(float value) {
        float scale = ScaleUtils.getFallingScale((Entity)this);
        if (scale != 1.0f && ((Boolean)PehkuiConfig.COMMON.scaledFallDamage.get()).booleanValue()) {
            return value / scale;
        }
        return value;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetEyeHeight(Pose pose, EntitySize dimensions, CallbackInfoReturnable<Float> info) {
        float scale;
        if (pose != Pose.SLEEPING && (scale = ScaleUtils.getEyeHeightScale((Entity)this)) != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void tickMovementModifyMinVelocity(CallbackInfo info, Vector3d velocity) {
        LivingEntity self = (LivingEntity)this;
        float scale = ScaleUtils.getMotionScale((Entity)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependantValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.field_72450_a;
            double vY = velocity.field_72448_b;
            double vZ = velocity.field_72449_c;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.func_213293_j(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float onApplyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @Inject(method={"getMaxHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetMaxHealth(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"getAttackDistanceScalingFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetAttackDistanceScalingFactor(@Nullable Entity entity, CallbackInfoReturnable<Double> info) {
        float scale = ScaleUtils.getVisibilityScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)(info.getReturnValueD() * (double)scale));
        }
    }

    @Inject(method={"applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onApplyClimbingSpeed(Vector3d motion, CallbackInfoReturnable<Vector3d> info) {
        LivingEntity self = (LivingEntity)this;
        if (!self.func_70617_f_()) {
            return;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f && !ScaleUtils.isAboveCollisionThreshold((Entity)self)) {
            AxisAlignedBB bounds = self.func_174813_aQ();
            double halfUnscaledXLength = bounds.func_216364_b() / (double)width / 2.0;
            int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a + halfUnscaledXLength));
            int maxX = MathHelper.func_76128_c((double)(bounds.field_72336_d - halfUnscaledXLength));
            int minY = MathHelper.func_76128_c((double)bounds.field_72338_b);
            double halfUnscaledZLength = bounds.func_216362_d() / (double)width / 2.0;
            int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c + halfUnscaledZLength));
            int maxZ = MathHelper.func_76128_c((double)(bounds.field_72334_f - halfUnscaledZLength));
            for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!self.field_70170_p.func_180495_p(pos).isScaffolding(self)) continue;
                Vector3d prev = (Vector3d)info.getReturnValue();
                info.setReturnValue((Object)new Vector3d(prev.field_72450_a, Math.max(self.func_213322_ci().field_72448_b, -0.15), prev.field_72449_c));
                break;
            }
        }
    }

    @Inject(method={"isClimbing()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onIsClimbing(CallbackInfoReturnable<Boolean> info) {
        LivingEntity self = (LivingEntity)this;
        if (info.getReturnValueZ() || self.func_175149_v()) {
            return;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f && !ScaleUtils.isAboveCollisionThreshold((Entity)self)) {
            AxisAlignedBB bounds = self.func_174813_aQ();
            double halfUnscaledXLength = bounds.func_216364_b() / (double)width / 2.0;
            int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a + halfUnscaledXLength));
            int maxX = MathHelper.func_76128_c((double)(bounds.field_72336_d - halfUnscaledXLength));
            int minY = MathHelper.func_76128_c((double)bounds.field_72338_b);
            double halfUnscaledZLength = bounds.func_216362_d() / (double)width / 2.0;
            int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c + halfUnscaledZLength));
            int maxZ = MathHelper.func_76128_c((double)(bounds.field_72334_f - halfUnscaledZLength));
            for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!self.field_70170_p.func_180495_p(pos).isLadder((IWorldReader)self.field_70170_p, pos, self)) continue;
                info.setReturnValue((Object)true);
                break;
            }
        }
    }
}

