/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.HorseInventoryContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={HorseInventoryContainer.class})
public class HorseScreenHandlerMixin {
    @Unique
    private static final ThreadLocal<Float> pehkui$REACH_SCALE = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));

    @Inject(method={"canUse"}, at={@At(value="HEAD")})
    private void onCanUse(PlayerEntity player, CallbackInfoReturnable<Boolean> info) {
        pehkui$REACH_SCALE.set(Float.valueOf(ScaleUtils.getEntityReachScale((Entity)player)));
    }

    @ModifyConstant(method={"canUse"}, constant={@Constant(floatValue=8.0f)})
    private float canUseModifyDistance(float value) {
        float scale = pehkui$REACH_SCALE.get().floatValue();
        return scale != 1.0f ? scale * value : value;
    }
}

