/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.TranslationTextComponent;
import virtuoel.pehkui.util.I18nUtils;

public class ScaleOperationArgumentType
implements ArgumentType<Operation> {
    private static final String[] SUGGESTIONS = new String[]{"set", "add", "subtract", "multiply", "divide", "power"};
    private static final Collection<String> EXAMPLES = Arrays.asList(SUGGESTIONS);
    private static final SimpleCommandExceptionType INVALID_OPERATION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("arguments.operation.invalid", I18nUtils.EMPTY_VARARGS));
    private static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("arguments.operation.div0", I18nUtils.EMPTY_VARARGS));

    public static ScaleOperationArgumentType operation() {
        return new ScaleOperationArgumentType();
    }

    public static Operation getOperation(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return (Operation)commandContext.getArgument(string, Operation.class);
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        return ScaleOperationArgumentType.getOperator(stringReader.getString().substring(i, stringReader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])SUGGESTIONS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperator(String string) throws CommandSyntaxException {
        switch (string) {
            case "set": {
                return (i, j) -> j;
            }
            case "add": {
                return (i, j) -> i + j;
            }
            case "subtract": {
                return (i, j) -> i - j;
            }
            case "multiply": {
                return (i, j) -> i * j;
            }
            case "divide": {
                return (i, j) -> {
                    if (j == 0.0f) {
                        throw DIVISION_ZERO_EXCEPTION.create();
                    }
                    return i / j;
                };
            }
            case "power": {
                return (i, j) -> (float)Math.pow(i, j);
            }
        }
        throw INVALID_OPERATION.create();
    }

    @FunctionalInterface
    public static interface Operation {
        public float apply(float var1, float var2) throws CommandSyntaxException;
    }
}

