/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.mixin.EntitySelectorOptionsInvoker;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.PehkuiEntitySelectorReaderExtensions;

public class PehkuiEntitySelectorOptions {
    public static final ITextComponent SCALE_RANGE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_range.description", "Entities with scale value");
    public static final ITextComponent SCALE_TYPE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_type.description", "Entities with scale type");

    public static void register() {
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleRange(MinMaxBounds.FloatBound.func_211357_a((StringReader)r.func_197398_f())), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleRange().func_211335_c(), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("computed_scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleRange(MinMaxBounds.FloatBound.func_211357_a((StringReader)r.func_197398_f())), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleRange().func_211335_c(), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("computed_scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
    }

    private static PehkuiEntitySelectorReaderExtensions cast(EntitySelectorParser reader) {
        return (PehkuiEntitySelectorReaderExtensions)reader;
    }

    private static ScaleType parseScaleType(EntitySelectorParser reader) throws CommandSyntaxException {
        reader.func_201978_a((builder, consumer) -> {
            CommandUtils.suggestIdentifiersIgnoringNamespace("pehkui", ScaleRegistries.SCALE_TYPES.keySet(), builder);
            return builder.buildFuture();
        });
        int i = reader.func_197398_f().getCursor();
        ResourceLocation id = ResourceLocation.func_195826_a((StringReader)reader.func_197398_f());
        ScaleType scaleType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, id);
        ResourceLocation defaultId = ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES);
        ScaleType defaultType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, defaultId);
        if (scaleType == null || scaleType == defaultType && !id.equals((Object)defaultId)) {
            reader.func_197398_f().setCursor(i);
            throw ScaleTypeArgumentType.INVALID_ENTRY_EXCEPTION.createWithContext((ImmutableStringReader)reader.func_197398_f(), (Object)id.toString());
        }
        return scaleType;
    }
}

