/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

public class ScaleType {
    private boolean defaultPersistence;
    private float defaultBaseScale;
    private int defaultTickDelay;
    private final ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction;
    private final ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction;
    private final Set<ScaleModifier> defaultBaseValueModifiers;
    private final Collection<ScaleEventCallback> scaleChangedEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> preTickEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> postTickEvent = new ArrayList<ScaleEventCallback>();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType INVALID = ScaleTypes.INVALID;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType BASE = ScaleTypes.BASE;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType WIDTH = ScaleTypes.WIDTH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType HEIGHT = ScaleTypes.HEIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType EYE_HEIGHT = ScaleTypes.EYE_HEIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType HITBOX_WIDTH = ScaleTypes.HITBOX_WIDTH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType HITBOX_HEIGHT = ScaleTypes.HITBOX_HEIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType MODEL_WIDTH = ScaleTypes.MODEL_WIDTH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType MODEL_HEIGHT = ScaleTypes.MODEL_HEIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType THIRD_PERSON = ScaleTypes.THIRD_PERSON;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType MOTION = ScaleTypes.MOTION;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType FALLING = ScaleTypes.FALLING;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType STEP_HEIGHT = ScaleTypes.STEP_HEIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType VIEW_BOBBING = ScaleTypes.VIEW_BOBBING;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType FLIGHT = ScaleTypes.FLIGHT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType REACH = ScaleTypes.REACH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType BLOCK_REACH = ScaleTypes.BLOCK_REACH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType ENTITY_REACH = ScaleTypes.ENTITY_REACH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType KNOCKBACK = ScaleTypes.KNOCKBACK;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType ATTACK = ScaleTypes.ATTACK;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType DEFENSE = ScaleTypes.DEFENSE;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType HEALTH = ScaleTypes.HEALTH;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType DROPS = ScaleTypes.DROPS;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType HELD_ITEM = ScaleTypes.HELD_ITEM;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType PROJECTILES = ScaleTypes.PROJECTILES;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleType EXPLOSIONS = ScaleTypes.EXPLOSIONS;

    private ScaleType(Builder builder) {
        this.defaultBaseScale = builder.defaultBaseScale;
        this.defaultTickDelay = builder.defaultTickDelay;
        this.defaultBaseValueModifiers = builder.defaultBaseValueModifiers;
        this.baseScaleClampFunction = builder.baseScaleClampFunction;
        this.targetScaleClampFunction = builder.targetScaleClampFunction;
        this.defaultPersistence = builder.defaultPersistence;
    }

    public ScaleData getScaleData(Entity entity) {
        return ((PehkuiEntityExtensions)entity).pehkui_getScaleData(this);
    }

    public void setDefaultPersistence(boolean persistent) {
        this.defaultPersistence = persistent;
    }

    public boolean getDefaultPersistence() {
        return this.defaultPersistence;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public boolean isPersistent() {
        return this.getDefaultPersistence();
    }

    public final float getDefaultBaseScale() {
        return this.defaultBaseScale;
    }

    public final int getDefaultTickDelay() {
        return this.defaultTickDelay;
    }

    public double clampBaseScale(ScaleData data, double newScale) {
        return this.baseScaleClampFunction.applyAsDouble(data, newScale);
    }

    public double clampTargetScale(ScaleData data, double newScale) {
        return this.targetScaleClampFunction.applyAsDouble(data, newScale);
    }

    public Set<ScaleModifier> getDefaultBaseValueModifiers() {
        return this.defaultBaseValueModifiers;
    }

    public Collection<ScaleEventCallback> getScaleChangedEvent() {
        return this.scaleChangedEvent;
    }

    public Collection<ScaleEventCallback> getPreTickEvent() {
        return this.preTickEvent;
    }

    public Collection<ScaleEventCallback> getPostTickEvent() {
        return this.postTickEvent;
    }

    public static class Builder {
        private Set<ScaleModifier> defaultBaseValueModifiers = new ObjectRBTreeSet();
        private float defaultBaseScale = 1.0f;
        private int defaultTickDelay = 20;
        private float defaultMinPositiveScale = 1.2621775E-29f;
        private float defaultMaxPositiveScale = 4.2949673E9f;
        private ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return scaleData.getTargetScale() < 0.0f ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return newScale < 0.0 ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private boolean affectsDimensions = false;
        private Set<ScaleModifier> dependentModifiers = new ObjectRBTreeSet();
        private boolean defaultPersistence = false;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder defaultBaseScale(float defaultBaseScale) {
            this.defaultBaseScale = defaultBaseScale;
            return this;
        }

        public Builder defaultTickDelay(int defaultTickDelay) {
            this.defaultTickDelay = defaultTickDelay;
            return this;
        }

        public Builder defaultMinPositiveScale(float defaultMinPositiveScale) {
            this.defaultMinPositiveScale = defaultMinPositiveScale;
            return this;
        }

        public Builder defaultMaxPositiveScale(float defaultMaxPositiveScale) {
            this.defaultMaxPositiveScale = defaultMaxPositiveScale;
            return this;
        }

        public Builder clampedBaseScale(ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction) {
            this.baseScaleClampFunction = baseScaleClampFunction;
            return this;
        }

        public Builder clampedTargetScale(ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction) {
            this.targetScaleClampFunction = targetScaleClampFunction;
            return this;
        }

        public Builder addBaseValueModifier(ScaleModifier scaleModifier) {
            this.defaultBaseValueModifiers.add(scaleModifier);
            return this;
        }

        public Builder defaultPersistence(boolean defaultPersistence) {
            this.defaultPersistence = defaultPersistence;
            return this;
        }

        public Builder affectsDimensions() {
            this.affectsDimensions = true;
            return this;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
        public Builder persistent() {
            this.defaultPersistence = true;
            return this;
        }

        public Builder addDependentModifier(ScaleModifier scaleModifier) {
            this.dependentModifiers.add(scaleModifier);
            return this;
        }

        public ScaleType build() {
            ScaleType type = new ScaleType(this);
            if (this.affectsDimensions) {
                type.getScaleChangedEvent().add(Builder::calculateDimensions);
            }
            if (!this.dependentModifiers.isEmpty()) {
                type.getScaleChangedEvent().add(Builder.createModifiedDataSyncEvent(this.dependentModifiers));
            }
            return type;
        }

        private static void calculateDimensions(ScaleData s) {
            Entity e = s.getEntity();
            if (e != null) {
                PehkuiEntityExtensions en = (PehkuiEntityExtensions)e;
                boolean onGround = en.pehkui_getOnGround();
                if (!ScaleUtils.isAboveCollisionThreshold(e)) {
                    e.func_213323_x_();
                }
                en.pehkui_setOnGround(onGround);
            }
        }

        private static ScaleEventCallback createModifiedDataSyncEvent(Collection<ScaleModifier> modifiers) {
            return s -> {
                Entity e = s.getEntity();
                if (e != null) {
                    for (ScaleType scaleType : ScaleRegistries.SCALE_TYPES.values()) {
                        ScaleData data = scaleType.getScaleData(e);
                        if (Collections.disjoint(modifiers, data.getBaseValueModifiers())) continue;
                        data.markForSync(true);
                    }
                }
            };
        }
    }
}

