/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.storage.data.IAEStack;
import appeng.me.cache.GridStorageCache;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ItemWatcher
implements IStackWatcher {
    private final GridStorageCache gsc;
    private final IStackWatcherHost myObject;
    private final Set<IAEStack> myInterests = new HashSet<IAEStack>();

    public ItemWatcher(GridStorageCache cache, IStackWatcherHost host) {
        this.gsc = cache;
        this.myObject = host;
    }

    public IStackWatcherHost getHost() {
        return this.myObject;
    }

    public boolean add(IAEStack e) {
        if (this.myInterests.contains(e)) {
            return false;
        }
        return this.myInterests.add((IAEStack)e.copy()) && this.gsc.getInterestManager().put(e, this);
    }

    public boolean remove(IAEStack o) {
        return this.myInterests.remove(o) && this.gsc.getInterestManager().remove(o, this);
    }

    @Override
    public void reset() {
        Iterator<IAEStack> i = this.myInterests.iterator();
        while (i.hasNext()) {
            this.gsc.getInterestManager().remove(i.next(), this);
            i.remove();
        }
    }
}

