/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.AELog;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AEFluidInventory
implements IAEFluidTank {
    private static final IAEFluidStack EMPTY_AE_FLUIDSTACK = null;
    private final IAEFluidStack[] fluids;
    private final IAEFluidInventory handler;
    private final int capacity;

    public AEFluidInventory(IAEFluidInventory handler, int slots, int capacity) {
        this.fluids = new IAEFluidStack[slots];
        this.handler = handler;
        this.capacity = capacity;
    }

    public AEFluidInventory(IAEFluidInventory handler, int slots) {
        this(handler, slots, Integer.MAX_VALUE);
    }

    @Override
    public void setFluidInSlot(int slot, IAEFluidStack fluid) {
        if (slot >= 0 && slot < this.getSlots()) {
            if (Objects.equals(this.fluids[slot], fluid)) {
                if (fluid != EMPTY_AE_FLUIDSTACK && fluid.getStackSize() != this.fluids[slot].getStackSize()) {
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                    this.onContentChanged(slot);
                }
            } else {
                if (fluid == EMPTY_AE_FLUIDSTACK) {
                    this.fluids[slot] = EMPTY_AE_FLUIDSTACK;
                } else {
                    this.fluids[slot] = fluid.copy();
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                }
                this.onContentChanged(slot);
            }
        }
    }

    private void onContentChanged(int slot) {
        if (this.handler != null && !this.handler.isRemote()) {
            this.handler.onFluidInventoryChanged(this, slot);
        }
    }

    @Override
    public IAEFluidStack getFluidInSlot(int slot) {
        if (slot >= 0 && slot < this.getSlots()) {
            return this.fluids[slot];
        }
        return EMPTY_AE_FLUIDSTACK;
    }

    @Override
    public int getSlots() {
        return this.fluids.length;
    }

    public int getTanks() {
        return this.fluids.length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.length) {
            return FluidStack.EMPTY;
        }
        return this.fluids[tank] == EMPTY_AE_FLUIDSTACK ? FluidStack.EMPTY : this.fluids[tank].getFluidStack();
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack != FluidStack.EMPTY;
    }

    public int fill(int slot, FluidStack resource, boolean doFill) {
        if (resource.isEmpty() || resource.getAmount() <= 0) {
            return 0;
        }
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid != EMPTY_AE_FLUIDSTACK && !fluid.getFluidStack().equals((Object)resource)) {
            return 0;
        }
        int amountToStore = this.capacity;
        if (fluid != EMPTY_AE_FLUIDSTACK) {
            amountToStore = (int)((long)amountToStore - fluid.getStackSize());
        }
        amountToStore = Math.min(amountToStore, resource.getAmount());
        if (doFill) {
            if (fluid == EMPTY_AE_FLUIDSTACK) {
                this.setFluidInSlot(slot, AEFluidStack.fromFluidStack(resource));
            } else {
                fluid.setStackSize(fluid.getStackSize() + (long)amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getAmount() <= 0) {
            return 0;
        }
        int slot = this.indexOfFluid(resource);
        if (slot == -1 && (slot = this.indexOfEmptySlot()) == -1) {
            return 0;
        }
        IAEFluidStack fluid = this.fluids[slot];
        int amountToStore = this.capacity;
        if (fluid != EMPTY_AE_FLUIDSTACK) {
            amountToStore = (int)((long)amountToStore - fluid.getStackSize());
        }
        amountToStore = Math.min(amountToStore, resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (fluid == EMPTY_AE_FLUIDSTACK) {
                this.setFluidInSlot(slot, AEFluidStack.fromFluidStack(resource));
            } else {
                fluid.setStackSize(fluid.getStackSize() + (long)amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public FluidStack drain(FluidStack fluid, IFluidHandler.FluidAction action) {
        if (fluid.isEmpty() || fluid.getAmount() <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack resource = fluid.copy();
        FluidStack totalDrained = FluidStack.EMPTY;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            FluidStack drain = this.drain(slot, resource, action == IFluidHandler.FluidAction.EXECUTE);
            if (drain.isEmpty()) continue;
            if (totalDrained.isEmpty()) {
                totalDrained = drain;
            } else {
                totalDrained.setAmount(totalDrained.getAmount() + drain.getAmount());
            }
            resource.setAmount(resource.getAmount() - drain.getAmount());
            if (resource.getAmount() <= 0) break;
        }
        return totalDrained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack totalDrained = FluidStack.EMPTY;
        int toDrain = maxDrain;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (totalDrained.isEmpty()) {
                totalDrained = this.drain(slot, toDrain, action == IFluidHandler.FluidAction.EXECUTE);
                if (totalDrained.isEmpty()) {
                    toDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(toDrain);
                FluidStack drain = this.drain(slot, copy, action == IFluidHandler.FluidAction.EXECUTE);
                if (!drain.isEmpty()) {
                    totalDrained.setAmount(totalDrained.getAmount() + drain.getAmount());
                    toDrain -= drain.getAmount();
                }
            }
            if (toDrain <= 0) break;
        }
        return totalDrained;
    }

    private int indexOfFluid(FluidStack resource) {
        for (int slot = 0; slot < this.fluids.length; ++slot) {
            if (this.fluids[slot] == EMPTY_AE_FLUIDSTACK || !this.fluids[slot].getFluidStack().isFluidEqual(resource)) continue;
            return slot;
        }
        return -1;
    }

    private int indexOfEmptySlot() {
        for (int slot = 0; slot < this.fluids.length; ++slot) {
            if (this.fluids[slot] != EMPTY_AE_FLUIDSTACK) continue;
            return slot;
        }
        return -1;
    }

    public FluidStack drain(int slot, FluidStack resource, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (resource.isEmpty() || fluid == EMPTY_AE_FLUIDSTACK || !fluid.getFluidStack().equals((Object)resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(slot, resource.getAmount(), doDrain);
    }

    public FluidStack drain(int slot, int maxDrain, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid == EMPTY_AE_FLUIDSTACK || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (fluid.getStackSize() < (long)drained) {
            drained = (int)fluid.getStackSize();
        }
        FluidStack stack = new FluidStack(fluid.getFluid(), drained);
        if (doDrain) {
            fluid.setStackSize(fluid.getStackSize() - (long)drained);
            if (fluid.getStackSize() <= 0L) {
                this.fluids[slot] = EMPTY_AE_FLUIDSTACK;
            }
            this.onContentChanged(slot);
        }
        return stack;
    }

    public void writeToNBT(CompoundNBT data, String name) {
        CompoundNBT c = new CompoundNBT();
        this.writeToNBT(c);
        data.func_218657_a(name, (INBT)c);
    }

    private void writeToNBT(CompoundNBT target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                CompoundNBT c = new CompoundNBT();
                if (this.fluids[x] != EMPTY_AE_FLUIDSTACK) {
                    this.fluids[x].writeToNBT(c);
                }
                target.func_218657_a("#" + x, (INBT)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(CompoundNBT data, String name) {
        CompoundNBT c = data.func_74775_l(name);
        if (!c.isEmpty()) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(CompoundNBT target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                CompoundNBT c = target.func_74775_l("#" + x);
                if (c.isEmpty()) continue;
                this.fluids[x] = AEFluidStack.fromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }
}

