/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.network;

import java.util.function.Supplier;
import lazy.baubles.api.cap.BaublesCapabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPacket {
    public int playerId;
    public byte slot;
    ItemStack bauble;

    public SyncPacket(PacketBuffer buf) {
        this.playerId = buf.readInt();
        this.slot = buf.readByte();
        this.bauble = buf.func_150791_c();
    }

    public SyncPacket(int playerId, byte slot, ItemStack bauble) {
        this.playerId = playerId;
        this.slot = slot;
        this.bauble = bauble;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.playerId);
        buf.writeByte((int)this.slot);
        buf.func_150788_a(this.bauble);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            Entity p = world.func_73045_a(this.playerId);
            if (p instanceof PlayerEntity) {
                p.getCapability(BaublesCapabilities.BAUBLES).ifPresent(b -> b.setStackInSlot(this.slot, this.bauble));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

