/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.datadriven;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lazy.baubles.api.bauble.BaubleType;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.datadriven.BaubleJson;
import lazy.baubles.datadriven.model.BaubleModel;
import lazy.baubles.datadriven.model.EffectModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BaubleJsonItem
extends Item
implements IBauble {
    public List<BaubleModel> model;

    public BaubleJsonItem(List<BaubleModel> model) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
        this.setRegistryName("bauble");
        this.model = model;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (group != this.func_77640_w()) {
            return;
        }
        this.model.forEach(model -> {
            for (String modId : model.getRequiredMods()) {
                if (ModList.get().isLoaded(modId)) continue;
                return;
            }
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_77982_d(new CompoundNBT());
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_74778_a("registryName", model.getRegistryName());
            }
            items.add((Object)stack);
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    model.getTooltips().forEach(s -> tooltip.add((ITextComponent)new StringTextComponent(s)));
                    if (model.canShowEffectsTooltip()) {
                        model.getEffects().forEach(effectModel -> {
                            if (!ForgeRegistries.POTIONS.containsKey(new ResourceLocation(effectModel.getEffectRegistryName()))) {
                                return;
                            }
                            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectModel.getEffectRegistryName()));
                            if (effect != null) {
                                StringTextComponent effectName = new StringTextComponent("");
                                effectName.func_240702_b_(effect.func_199286_c().getString() + " " + this.getFromInteger(Math.min(effectModel.getEffectLevel(), 99)));
                                tooltip.add((ITextComponent)effectName);
                            }
                        });
                    }
                }
            });
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        AtomicBoolean has = new AtomicBoolean(false);
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    has.set(model.isGlint());
                }
            });
        }
        return has.get();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        StringTextComponent textComponent = new StringTextComponent("");
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    textComponent.func_240702_b_(model.getDisplayName());
                }
            });
        }
        return textComponent.getString().equals("") ? super.func_200295_i(stack) : textComponent;
    }

    @Override
    public BaubleType getBaubleType(ItemStack stack) {
        StringBuilder type = new StringBuilder();
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    type.append(model.getType());
                }
            });
        }
        return BaubleType.getFromString(type.toString());
    }

    @Override
    public void onEquipped(LivingEntity player, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    for (EffectModel effectModel : model.getEffects()) {
                        Effect effect;
                        if (!ForgeRegistries.POTIONS.containsKey(new ResourceLocation(effectModel.getEffectRegistryName())) || (effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectModel.getEffectRegistryName()))) == null) continue;
                        player.func_195064_c(new EffectInstance(effect, 999999, Math.min(effectModel.getEffectLevel(), 99)));
                    }
                }
            });
        }
    }

    @Override
    public void onUnequipped(LivingEntity player, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            this.model.forEach(model -> {
                if (this.isRing(stack, model.getRegistryName())) {
                    for (EffectModel effectModel : model.getEffects()) {
                        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectModel.getEffectRegistryName()));
                        if (effect == null) continue;
                        player.func_195063_d(effect);
                    }
                }
            });
        }
    }

    private boolean isRing(ItemStack stack, String registryName) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("registryName") && stack.func_77978_p().func_74779_i("registryName").equals(registryName);
    }

    public void setModel(List<BaubleModel> loadBaubles) {
        this.model = loadBaubles;
    }

    public String getFromInteger(int integer) {
        switch (integer) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
            case 5: {
                return "VI";
            }
            case 6: {
                return "VII";
            }
            case 7: {
                return "VIII";
            }
            case 8: {
                return "IX";
            }
            case 9: {
                return "X";
            }
        }
        return String.valueOf(integer);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Reg {
        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> e) {
            if (!BaubleJson.loadBaubles().isEmpty()) {
                e.getRegistry().register((IForgeRegistryEntry)new BaubleJsonItem(BaubleJson.loadBaubles()));
            }
        }
    }
}

