/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.api.bauble;

public enum BaubleType {
    AMULET(0),
    RING(1, 2),
    BELT(3),
    TRINKET(0, 1, 2, 3, 4, 5, 6),
    HEAD(4),
    BODY(5),
    CHARM(6);

    int[] validSlots;

    private BaubleType(int ... validSlots) {
        this.validSlots = validSlots;
    }

    public boolean hasSlot(int slot) {
        for (int s : this.validSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public int[] getValidSlots() {
        return this.validSlots;
    }

    public static BaubleType getFromString(String type) {
        switch (type) {
            case "ring": {
                return RING;
            }
            case "amulet": {
                return AMULET;
            }
            case "belt": {
                return BELT;
            }
            case "head": {
                return HEAD;
            }
            case "body": {
                return BODY;
            }
            case "charm": {
                return CHARM;
            }
        }
        return TRINKET;
    }
}

